rule win_himan_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.himan."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.himan"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4608 57 57 57 50 }
            // n = 5, score = 100
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   57                   | push                edi
            //   57                   | push                edi
            //   57                   | push                edi
            //   50                   | push                eax

        $sequence_1 = { 33d5 8bee 81e5ff000000 c1ee08 3314adbcba6e00 8b28 }
            // n = 6, score = 100
            //   33d5                 | xor                 edx, ebp
            //   8bee                 | mov                 ebp, esi
            //   81e5ff000000         | and                 ebp, 0xff
            //   c1ee08               | shr                 esi, 8
            //   3314adbcba6e00       | xor                 edx, dword ptr [ebp*4 + 0x6ebabc]
            //   8b28                 | mov                 ebp, dword ptr [eax]

        $sequence_2 = { 8bf9 85c0 7505 e8???????? 8b442418 8b4c2414 }
            // n = 6, score = 100
            //   8bf9                 | mov                 edi, ecx
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7
            //   e8????????           |                     
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]

        $sequence_3 = { 8a83bc986e00 2bc8 8a11 eb02 32d2 8ac2 8aca }
            // n = 7, score = 100
            //   8a83bc986e00         | mov                 al, byte ptr [ebx + 0x6e98bc]
            //   2bc8                 | sub                 ecx, eax
            //   8a11                 | mov                 dl, byte ptr [ecx]
            //   eb02                 | jmp                 4
            //   32d2                 | xor                 dl, dl
            //   8ac2                 | mov                 al, dl
            //   8aca                 | mov                 cl, dl

        $sequence_4 = { c1e604 0bce 7c0b 83f940 }
            // n = 4, score = 100
            //   c1e604               | shl                 esi, 4
            //   0bce                 | or                  ecx, esi
            //   7c0b                 | jl                  0xd
            //   83f940               | cmp                 ecx, 0x40

        $sequence_5 = { ffd5 85c0 74d4 8b442438 85c0 74cc 03f0 }
            // n = 7, score = 100
            //   ffd5                 | call                ebp
            //   85c0                 | test                eax, eax
            //   74d4                 | je                  0xffffffd6
            //   8b442438             | mov                 eax, dword ptr [esp + 0x38]
            //   85c0                 | test                eax, eax
            //   74cc                 | je                  0xffffffce
            //   03f0                 | add                 esi, eax

        $sequence_6 = { c1ee10 8bd7 81e6ff000000 c1ea08 8b2cb5bca16e00 81e2ff000000 }
            // n = 6, score = 100
            //   c1ee10               | shr                 esi, 0x10
            //   8bd7                 | mov                 edx, edi
            //   81e6ff000000         | and                 esi, 0xff
            //   c1ea08               | shr                 edx, 8
            //   8b2cb5bca16e00       | mov                 ebp, dword ptr [esi*4 + 0x6ea1bc]
            //   81e2ff000000         | and                 edx, 0xff

        $sequence_7 = { 8d4c2414 50 51 52 ff15???????? 85c0 7478 }
            // n = 7, score = 100
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   52                   | push                edx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7478                 | je                  0x7a

        $sequence_8 = { 83c408 85c0 7451 8d8c24e0000000 68???????? 51 }
            // n = 6, score = 100
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   7451                 | je                  0x53
            //   8d8c24e0000000       | lea                 ecx, [esp + 0xe0]
            //   68????????           |                     
            //   51                   | push                ecx

        $sequence_9 = { f3ab 8d44241c 50 ff15???????? 8d4c2418 68???????? 51 }
            // n = 7, score = 100
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8d44241c             | lea                 eax, [esp + 0x1c]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   68????????           |                     
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 139264
}