rule win_himera_loader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.himera_loader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.himera_loader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c645e656 c645e70e c645e801 c645e90e c645ea18 c645eb1a }
            // n = 6, score = 200
            //   c645e656             | mov                 byte ptr [ebp - 0x1a], 0x56
            //   c645e70e             | mov                 byte ptr [ebp - 0x19], 0xe
            //   c645e801             | mov                 byte ptr [ebp - 0x18], 1
            //   c645e90e             | mov                 byte ptr [ebp - 0x17], 0xe
            //   c645ea18             | mov                 byte ptr [ebp - 0x16], 0x18
            //   c645eb1a             | mov                 byte ptr [ebp - 0x15], 0x1a

        $sequence_1 = { 83e03f c1f906 6bd038 8b0c8d00a14200 804c112802 5b }
            // n = 6, score = 200
            //   83e03f               | and                 eax, 0x3f
            //   c1f906               | sar                 ecx, 6
            //   6bd038               | imul                edx, eax, 0x38
            //   8b0c8d00a14200       | mov                 ecx, dword ptr [ecx*4 + 0x42a100]
            //   804c112802           | or                  byte ptr [ecx + edx + 0x28], 2
            //   5b                   | pop                 ebx

        $sequence_2 = { 83bd00faffff00 7409 83bd1cfaffff00 7504 33c0 }
            // n = 5, score = 200
            //   83bd00faffff00       | cmp                 dword ptr [ebp - 0x600], 0
            //   7409                 | je                  0xb
            //   83bd1cfaffff00       | cmp                 dword ptr [ebp - 0x5e4], 0
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { 0f84d3000000 8b048d7c3c4200 89858cf8ffff 85c0 0f8498000000 83f801 0f84b5000000 }
            // n = 7, score = 200
            //   0f84d3000000         | je                  0xd9
            //   8b048d7c3c4200       | mov                 eax, dword ptr [ecx*4 + 0x423c7c]
            //   89858cf8ffff         | mov                 dword ptr [ebp - 0x774], eax
            //   85c0                 | test                eax, eax
            //   0f8498000000         | je                  0x9e
            //   83f801               | cmp                 eax, 1
            //   0f84b5000000         | je                  0xbb

        $sequence_4 = { 6689411e 6a10 ba02000000 c1e204 8b4508 0fb70c10 }
            // n = 6, score = 200
            //   6689411e             | mov                 word ptr [ecx + 0x1e], ax
            //   6a10                 | push                0x10
            //   ba02000000           | mov                 edx, 2
            //   c1e204               | shl                 edx, 4
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   0fb70c10             | movzx               ecx, word ptr [eax + edx]

        $sequence_5 = { 0fb6d0 85d2 744c 8d4df0 e8???????? 8945e8 8b45e8 }
            // n = 7, score = 200
            //   0fb6d0               | movzx               edx, al
            //   85d2                 | test                edx, edx
            //   744c                 | je                  0x4e
            //   8d4df0               | lea                 ecx, [ebp - 0x10]
            //   e8????????           |                     
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]

        $sequence_6 = { e8???????? 83c404 33d2 88957582ffff }
            // n = 4, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   33d2                 | xor                 edx, edx
            //   88957582ffff         | mov                 byte ptr [ebp - 0x7d8b], dl

        $sequence_7 = { 8d950c82ffff 52 8d85ec81ffff 50 8d8de881ffff 51 }
            // n = 6, score = 200
            //   8d950c82ffff         | lea                 edx, [ebp - 0x7df4]
            //   52                   | push                edx
            //   8d85ec81ffff         | lea                 eax, [ebp - 0x7e14]
            //   50                   | push                eax
            //   8d8de881ffff         | lea                 ecx, [ebp - 0x7e18]
            //   51                   | push                ecx

        $sequence_8 = { 8945f0 50 8d45f4 64a300000000 894da4 c745a048000000 c645a846 }
            // n = 7, score = 200
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   894da4               | mov                 dword ptr [ebp - 0x5c], ecx
            //   c745a048000000       | mov                 dword ptr [ebp - 0x60], 0x48
            //   c645a846             | mov                 byte ptr [ebp - 0x58], 0x46

        $sequence_9 = { e8???????? 8bc8 e8???????? 50 8b8d3082ffff }
            // n = 5, score = 200
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   50                   | push                eax
            //   8b8d3082ffff         | mov                 ecx, dword ptr [ebp - 0x7dd0]

    condition:
        7 of them and filesize < 385024
}