rule win_hlux_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hlux."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hlux"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7406 899d44ffffff 09c9 7506 898d9cfeffff 83ffd6 }
            // n = 6, score = 100
            //   7406                 | je                  8
            //   899d44ffffff         | mov                 dword ptr [ebp - 0xbc], ebx
            //   09c9                 | or                  ecx, ecx
            //   7506                 | jne                 8
            //   898d9cfeffff         | mov                 dword ptr [ebp - 0x164], ecx
            //   83ffd6               | cmp                 edi, -0x2a

        $sequence_1 = { 7503 895598 8b9decfeffff 8d0b 09db }
            // n = 5, score = 100
            //   7503                 | jne                 5
            //   895598               | mov                 dword ptr [ebp - 0x68], edx
            //   8b9decfeffff         | mov                 ebx, dword ptr [ebp - 0x114]
            //   8d0b                 | lea                 ecx, [ebx]
            //   09db                 | or                  ebx, ebx

        $sequence_2 = { 0009 1b4e01 e405 9d }
            // n = 4, score = 100
            //   0009                 | add                 byte ptr [ecx], cl
            //   1b4e01               | sbb                 ecx, dword ptr [esi + 1]
            //   e405                 | in                  al, 5
            //   9d                   | popfd               

        $sequence_3 = { 0088aa4b0023 d18a0688078a 46 018847018a46 }
            // n = 4, score = 100
            //   0088aa4b0023         | add                 byte ptr [eax + 0x23004baa], cl
            //   d18a0688078a         | ror                 dword ptr [edx - 0x75f877fa], 1
            //   46                   | inc                 esi
            //   018847018a46         | add                 dword ptr [eax + 0x468a0147], ecx

        $sequence_4 = { 0000 008365f0fe8b 4d 0883c108e918 }
            // n = 4, score = 100
            //   0000                 | add                 byte ptr [eax], al
            //   008365f0fe8b         | add                 byte ptr [ebx - 0x74010f9b], al
            //   4d                   | dec                 ebp
            //   0883c108e918         | or                  byte ptr [ebx + 0x18e908c1], al

        $sequence_5 = { 0130 8b13 8b08 85d2 }
            // n = 4, score = 100
            //   0130                 | add                 dword ptr [eax], esi
            //   8b13                 | mov                 edx, dword ptr [ebx]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   85d2                 | test                edx, edx

        $sequence_6 = { 33db 81f926edf50a 742f 8d144b 8d8c8b9948a5f2 8955f0 83f909 }
            // n = 7, score = 100
            //   33db                 | xor                 ebx, ebx
            //   81f926edf50a         | cmp                 ecx, 0xaf5ed26
            //   742f                 | je                  0x31
            //   8d144b               | lea                 edx, [ebx + ecx*2]
            //   8d8c8b9948a5f2       | lea                 ecx, [ebx + ecx*4 - 0xd5ab767]
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx
            //   83f909               | cmp                 ecx, 9

        $sequence_7 = { 7534 85c9 7430 83f9f4 }
            // n = 4, score = 100
            //   7534                 | jne                 0x36
            //   85c9                 | test                ecx, ecx
            //   7430                 | je                  0x32
            //   83f9f4               | cmp                 ecx, -0xc

        $sequence_8 = { bba43c0cdb 8b15???????? 8955c4 895de0 83f8c1 7503 8945d8 }
            // n = 7, score = 100
            //   bba43c0cdb           | mov                 ebx, 0xdb0c3ca4
            //   8b15????????         |                     
            //   8955c4               | mov                 dword ptr [ebp - 0x3c], edx
            //   895de0               | mov                 dword ptr [ebp - 0x20], ebx
            //   83f8c1               | cmp                 eax, -0x3f
            //   7503                 | jne                 5
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax

        $sequence_9 = { 010f 840f 0000 008365f0fe8b }
            // n = 4, score = 100
            //   010f                 | add                 dword ptr [edi], ecx
            //   840f                 | test                byte ptr [edi], cl
            //   0000                 | add                 byte ptr [eax], al
            //   008365f0fe8b         | add                 byte ptr [ebx - 0x74010f9b], al

        $sequence_10 = { 0104bb 8d1447 89542418 e9???????? }
            // n = 4, score = 100
            //   0104bb               | add                 dword ptr [ebx + edi*4], eax
            //   8d1447               | lea                 edx, [edi + eax*2]
            //   89542418             | mov                 dword ptr [esp + 0x18], edx
            //   e9????????           |                     

        $sequence_11 = { 0101 c9 c3 6a10 }
            // n = 4, score = 100
            //   0101                 | add                 dword ptr [ecx], eax
            //   c9                   | leave               
            //   c3                   | ret                 
            //   6a10                 | push                0x10

        $sequence_12 = { 0104b9 33c9 83c408 85c0 }
            // n = 4, score = 100
            //   0104b9               | add                 dword ptr [ecx + edi*4], eax
            //   33c9                 | xor                 ecx, ecx
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax

        $sequence_13 = { 898d84feffff 8b0d???????? 8b1d???????? 899d0cffffff }
            // n = 4, score = 100
            //   898d84feffff         | mov                 dword ptr [ebp - 0x17c], ecx
            //   8b0d????????         |                     
            //   8b1d????????         |                     
            //   899d0cffffff         | mov                 dword ptr [ebp - 0xf4], ebx

        $sequence_14 = { 83f8a6 7406 89851cffffff 8b1d???????? 895df4 8b3d???????? }
            // n = 6, score = 100
            //   83f8a6               | cmp                 eax, -0x5a
            //   7406                 | je                  8
            //   89851cffffff         | mov                 dword ptr [ebp - 0xe4], eax
            //   8b1d????????         |                     
            //   895df4               | mov                 dword ptr [ebp - 0xc], ebx
            //   8b3d????????         |                     

        $sequence_15 = { 89bd64ffffff 09c0 750b 83f8c1 7406 }
            // n = 5, score = 100
            //   89bd64ffffff         | mov                 dword ptr [ebp - 0x9c], edi
            //   09c0                 | or                  eax, eax
            //   750b                 | jne                 0xd
            //   83f8c1               | cmp                 eax, -0x3f
            //   7406                 | je                  8

    condition:
        7 of them and filesize < 3147776
}