rule win_hodur_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hodur."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hodur"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 83c414 0f2805???????? 833d????????0a 0f11442468 66c74424781b3e c644247a00 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   83c414               | add                 esp, 0x14
            //   0f2805????????       |                     
            //   833d????????0a       |                     
            //   0f11442468           | movups              xmmword ptr [esp + 0x68], xmm0
            //   66c74424781b3e       | mov                 word ptr [esp + 0x78], 0x3e1b
            //   c644247a00           | mov                 byte ptr [esp + 0x7a], 0

        $sequence_1 = { 8b15???????? 8b3d???????? 8d42ff 0fafc2 83e001 83ff0a 7c15 }
            // n = 7, score = 100
            //   8b15????????         |                     
            //   8b3d????????         |                     
            //   8d42ff               | lea                 eax, [edx - 1]
            //   0fafc2               | imul                eax, edx
            //   83e001               | and                 eax, 1
            //   83ff0a               | cmp                 edi, 0xa
            //   7c15                 | jl                  0x17

        $sequence_2 = { c684243801000000 7c0f 8d48ff 0fafc8 83e101 0f85a0260000 8d8c2430010000 }
            // n = 7, score = 100
            //   c684243801000000     | mov                 byte ptr [esp + 0x138], 0
            //   7c0f                 | jl                  0x11
            //   8d48ff               | lea                 ecx, [eax - 1]
            //   0fafc8               | imul                ecx, eax
            //   83e101               | and                 ecx, 1
            //   0f85a0260000         | jne                 0x26a6
            //   8d8c2430010000       | lea                 ecx, [esp + 0x130]

        $sequence_3 = { 7c0b 8d41ff 0fafc1 83e001 752a 6a5c 55 }
            // n = 7, score = 100
            //   7c0b                 | jl                  0xd
            //   8d41ff               | lea                 eax, [ecx - 1]
            //   0fafc1               | imul                eax, ecx
            //   83e001               | and                 eax, 1
            //   752a                 | jne                 0x2c
            //   6a5c                 | push                0x5c
            //   55                   | push                ebp

        $sequence_4 = { c74424080c043500 7c14 a1???????? 8d48ff 0fafc8 83e101 0f85b10b0000 }
            // n = 7, score = 100
            //   c74424080c043500     | mov                 dword ptr [esp + 8], 0x35040c
            //   7c14                 | jl                  0x16
            //   a1????????           |                     
            //   8d48ff               | lea                 ecx, [eax - 1]
            //   0fafc8               | imul                ecx, eax
            //   83e101               | and                 ecx, 1
            //   0f85b10b0000         | jne                 0xbb7

        $sequence_5 = { 6a5c 8d842454040000 50 e8???????? 83c408 833d????????0a 89c7 }
            // n = 7, score = 100
            //   6a5c                 | push                0x5c
            //   8d842454040000       | lea                 eax, [esp + 0x454]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   833d????????0a       |                     
            //   89c7                 | mov                 edi, eax

        $sequence_6 = { c78424e0000000b9ffceff 7c15 8b0d???????? 8d51ff 0fafd1 83e201 0f85ab0a0000 }
            // n = 7, score = 100
            //   c78424e0000000b9ffceff     | mov    dword ptr [esp + 0xe0], 0xffceffb9
            //   7c15                 | jl                  0x17
            //   8b0d????????         |                     
            //   8d51ff               | lea                 edx, [ecx - 1]
            //   0fafd1               | imul                edx, ecx
            //   83e201               | and                 edx, 1
            //   0f85ab0a0000         | jne                 0xab1

        $sequence_7 = { ebfe 833d????????0a 66c784249a0000000000 7c12 a1???????? 8d48ff 0fafc8 }
            // n = 7, score = 100
            //   ebfe                 | jmp                 0
            //   833d????????0a       |                     
            //   66c784249a0000000000     | mov    word ptr [esp + 0x9a], 0
            //   7c12                 | jl                  0x14
            //   a1????????           |                     
            //   8d48ff               | lea                 ecx, [eax - 1]
            //   0fafc8               | imul                ecx, eax

        $sequence_8 = { 7c0d 8d50ff 0fafd0 83e201 7402 ebfe e8???????? }
            // n = 7, score = 100
            //   7c0d                 | jl                  0xf
            //   8d50ff               | lea                 edx, [eax - 1]
            //   0fafd0               | imul                edx, eax
            //   83e201               | and                 edx, 1
            //   7402                 | je                  4
            //   ebfe                 | jmp                 0
            //   e8????????           |                     

        $sequence_9 = { 75f4 c6410d00 e8???????? 53 ff75e4 ffd0 833d????????0a }
            // n = 7, score = 100
            //   75f4                 | jne                 0xfffffff6
            //   c6410d00             | mov                 byte ptr [ecx + 0xd], 0
            //   e8????????           |                     
            //   53                   | push                ebx
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   ffd0                 | call                eax
            //   833d????????0a       |                     

    condition:
        7 of them and filesize < 1067008
}