rule win_hookinjex_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hookinjex."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hookinjex"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? b80a020000 eb02 33c0 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   b80a020000           | dec                 eax
            //   eb02                 | mov                 eax, dword ptr [esp + 0x68]
            //   33c0                 | mov                 eax, dword ptr [eax]

        $sequence_1 = { e8???????? 85c0 750f b9ab480100 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   750f                 | cmp                 dword ptr [eax + 8], 0
            //   b9ab480100           | jne                 0x19

        $sequence_2 = { e8???????? b95b730100 e8???????? e9???????? }
            // n = 4, score = 300
            //   e8????????           |                     
            //   b95b730100           | dec                 eax
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_3 = { e8???????? 833d????????00 7411 b903000000 e8???????? 488905???????? }
            // n = 6, score = 300
            //   e8????????           |                     
            //   833d????????00       |                     
            //   7411                 | dec                 eax
            //   b903000000           | mov                 eax, dword ptr [esp + 0x50]
            //   e8????????           |                     
            //   488905????????       |                     

        $sequence_4 = { e8???????? 85c0 740f b907b60000 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   740f                 | jne                 0x11
            //   b907b60000           | mov                 ecx, 0x148ab

        $sequence_5 = { e8???????? b964000000 ff15???????? 0fb705???????? }
            // n = 4, score = 300
            //   e8????????           |                     
            //   b964000000           | mov                 eax, dword ptr [eax]
            //   ff15????????         |                     
            //   0fb705????????       |                     

        $sequence_6 = { e8???????? 833d????????00 7411 b906000000 e8???????? 488905???????? }
            // n = 6, score = 300
            //   e8????????           |                     
            //   833d????????00       |                     
            //   7411                 | inc                 eax
            //   b906000000           | dec                 eax
            //   e8????????           |                     
            //   488905????????       |                     

        $sequence_7 = { e8???????? 85c0 740c b913e40000 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   740c                 | mov                 ecx, dword ptr [esp + 0x50]
            //   b913e40000           | mov                 dword ptr [ecx], eax

        $sequence_8 = { 4883780800 7512 488b442450 8b00 }
            // n = 4, score = 200
            //   4883780800           | mov                 dword ptr [esp + 0x3c], eax
            //   7512                 | mov                 eax, dword ptr [esp + 0x3c]
            //   488b442450           | mov                 dword ptr [esp + 0x20], eax
            //   8b00                 | jmp                 0xa2

        $sequence_9 = { 0f843d010000 488b442440 488b4c2470 488b4920 }
            // n = 4, score = 200
            //   0f843d010000         | mov                 ecx, dword ptr [esp + 0x68]
            //   488b442440           | mov                 dword ptr [ecx], eax
            //   488b4c2470           | dec                 eax
            //   488b4920             | mov                 edx, dword ptr [esp + 0x70]

        $sequence_10 = { 25ff9fffff 89442420 8b442420 89442448 }
            // n = 4, score = 200
            //   25ff9fffff           | mov                 dword ptr [esp + 0x50], ecx
            //   89442420             | and                 eax, 0xfff
            //   8b442420             | mov                 dword ptr [esp + 0x48], eax
            //   89442448             | dec                 eax

        $sequence_11 = { 03442460 488b4c2468 8901 e9???????? 488b542470 488d4c2430 }
            // n = 6, score = 200
            //   03442460             | add                 eax, dword ptr [esp + 0x60]
            //   488b4c2468           | dec                 eax
            //   8901                 | mov                 ecx, dword ptr [esp + 0x68]
            //   e9????????           |                     
            //   488b542470           | mov                 dword ptr [ecx], eax
            //   488d4c2430           | dec                 eax

        $sequence_12 = { 25ffe7ffff 0fbae80b 8944243c 8b44243c }
            // n = 4, score = 200
            //   25ffe7ffff           | jmp                 0x27
            //   0fbae80b             | mov                 eax, dword ptr [esp + 0x20]
            //   8944243c             | and                 eax, 0xffffe7ff
            //   8b44243c             | bts                 eax, 0xb

        $sequence_13 = { 25ffe7ffff 0fbae80b 89442420 8b442420 89442468 }
            // n = 5, score = 200
            //   25ffe7ffff           | and                 eax, 0x18
            //   0fbae80b             | mov                 dword ptr [esp + 0x34], eax
            //   89442420             | and                 eax, 0xffffe7ff
            //   8b442420             | bts                 eax, 0xb
            //   89442468             | mov                 dword ptr [esp + 0x20], eax

        $sequence_14 = { 25ff0f0000 89442448 488b0d???????? 48894c2450 }
            // n = 4, score = 200
            //   25ff0f0000           | dec                 eax
            //   89442448             | mov                 ecx, dword ptr [esp + 0x70]
            //   488b0d????????       |                     
            //   48894c2450           | dec                 eax

        $sequence_15 = { 25ffe7ffff 0fbae80b 8944245c 8b44245c }
            // n = 4, score = 200
            //   25ffe7ffff           | mov                 dword ptr [esp + 0x3c], eax
            //   0fbae80b             | mov                 eax, dword ptr [esp + 0x3c]
            //   8944245c             | and                 eax, 0xffffe7ff
            //   8b44245c             | bts                 eax, 0xb

    condition:
        7 of them and filesize < 6545408
}