rule win_hotcroissant_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hotcroissant."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hotcroissant"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 52 6a00 68703a0000 6a00 }
            // n = 4, score = 600
            //   52                   | push                edx
            //   6a00                 | push                0
            //   68703a0000           | push                0x3a70
            //   6a00                 | push                0

        $sequence_1 = { 6a00 c705????????00000000 ff15???????? 6a00 }
            // n = 4, score = 600
            //   6a00                 | push                0
            //   c705????????00000000     |     
            //   ff15????????         |                     
            //   6a00                 | push                0

        $sequence_2 = { 52 50 6a08 ff15???????? 50 ff15???????? 85c0 }
            // n = 7, score = 600
            //   52                   | push                edx
            //   50                   | push                eax
            //   6a08                 | push                8
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_3 = { ffd6 6800040000 68???????? 68???????? 68???????? ffd6 }
            // n = 6, score = 600
            //   ffd6                 | call                esi
            //   6800040000           | push                0x400
            //   68????????           |                     
            //   68????????           |                     
            //   68????????           |                     
            //   ffd6                 | call                esi

        $sequence_4 = { 6a01 50 ff15???????? a1???????? 8b35???????? 50 ffd6 }
            // n = 7, score = 600
            //   6a01                 | push                1
            //   50                   | push                eax
            //   ff15????????         |                     
            //   a1????????           |                     
            //   8b35????????         |                     
            //   50                   | push                eax
            //   ffd6                 | call                esi

        $sequence_5 = { 8b15???????? 33c0 52 a3???????? a3???????? a3???????? }
            // n = 6, score = 600
            //   8b15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   52                   | push                edx
            //   a3????????           |                     
            //   a3????????           |                     
            //   a3????????           |                     

        $sequence_6 = { 8b15???????? 52 ffd6 893d???????? }
            // n = 4, score = 600
            //   8b15????????         |                     
            //   52                   | push                edx
            //   ffd6                 | call                esi
            //   893d????????         |                     

        $sequence_7 = { 56 57 683f000f00 33db 53 53 ff15???????? }
            // n = 7, score = 600
            //   56                   | push                esi
            //   57                   | push                edi
            //   683f000f00           | push                0xf003f
            //   33db                 | xor                 ebx, ebx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   ff15????????         |                     

        $sequence_8 = { ffd7 807c30ff5c 8b1d???????? 740a }
            // n = 4, score = 600
            //   ffd7                 | call                edi
            //   807c30ff5c           | cmp                 byte ptr [eax + esi - 1], 0x5c
            //   8b1d????????         |                     
            //   740a                 | je                  0xc

        $sequence_9 = { 8b15???????? 33c0 52 a3???????? a3???????? }
            // n = 5, score = 600
            //   8b15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   52                   | push                edx
            //   a3????????           |                     
            //   a3????????           |                     

    condition:
        7 of them and filesize < 591872
}