rule win_htran_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.htran."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.htran"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b942430510000 55 52 68???????? e8???????? }
            // n = 5, score = 200
            //   8b942430510000       | mov                 edx, dword ptr [esp + 0x5130]
            //   55                   | push                ebp
            //   52                   | push                edx
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_1 = { e8???????? 83c404 e9???????? 68???????? e8???????? 8b942430510000 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   e9????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   8b942430510000       | mov                 edx, dword ptr [esp + 0x5130]

        $sequence_2 = { 8d3449 8d34b5f09b4000 83c00c 3bc6 7305 }
            // n = 5, score = 200
            //   8d3449               | lea                 esi, [ecx + ecx*2]
            //   8d34b5f09b4000       | lea                 esi, [esi*4 + 0x409bf0]
            //   83c00c               | add                 eax, 0xc
            //   3bc6                 | cmp                 eax, esi
            //   7305                 | jae                 7

        $sequence_3 = { 68???????? 6a02 e8???????? 8bb42400020000 83c408 83fe02 0f8ef0000000 }
            // n = 7, score = 200
            //   68????????           |                     
            //   6a02                 | push                2
            //   e8????????           |                     
            //   8bb42400020000       | mov                 esi, dword ptr [esp + 0x200]
            //   83c408               | add                 esp, 8
            //   83fe02               | cmp                 esi, 2
            //   0f8ef0000000         | jle                 0xf6

        $sequence_4 = { 5e 83c414 c3 6a05 }
            // n = 4, score = 200
            //   5e                   | pop                 esi
            //   83c414               | add                 esp, 0x14
            //   c3                   | ret                 
            //   6a05                 | push                5

        $sequence_5 = { 8b8424e0420100 33c9 894c2414 53 8b10 }
            // n = 5, score = 200
            //   8b8424e0420100       | mov                 eax, dword ptr [esp + 0x142e0]
            //   33c9                 | xor                 ecx, ecx
            //   894c2414             | mov                 dword ptr [esp + 0x14], ecx
            //   53                   | push                ebx
            //   8b10                 | mov                 edx, dword ptr [eax]

        $sequence_6 = { ff15???????? 85c0 7d14 68???????? e8???????? 83c404 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7d14                 | jge                 0x16
            //   68????????           |                     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_7 = { c3 6a00 6a01 6a02 ff15???????? 85c0 }
            // n = 6, score = 200
            //   c3                   | ret                 
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   6a02                 | push                2
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_8 = { 8816 46 8a10 40 0fb6da f683c1c3400004 740c }
            // n = 7, score = 200
            //   8816                 | mov                 byte ptr [esi], dl
            //   46                   | inc                 esi
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   40                   | inc                 eax
            //   0fb6da               | movzx               ebx, dl
            //   f683c1c3400004       | test                byte ptr [ebx + 0x40c3c1], 4
            //   740c                 | je                  0xe

        $sequence_9 = { 899424e8010000 89b424e8000000 899424e4000000 33c0 8d8c24e8000000 }
            // n = 5, score = 200
            //   899424e8010000       | mov                 dword ptr [esp + 0x1e8], edx
            //   89b424e8000000       | mov                 dword ptr [esp + 0xe8], esi
            //   899424e4000000       | mov                 dword ptr [esp + 0xe4], edx
            //   33c0                 | xor                 eax, eax
            //   8d8c24e8000000       | lea                 ecx, [esp + 0xe8]

    condition:
        7 of them and filesize < 114688
}