rule win_httpdropper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.httpdropper."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.httpdropper"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bd8 8985d0f0ffff 85db 0f8482000000 6a3c 8d8554f0ffff 6a00 }
            // n = 7, score = 200
            //   8bd8                 | inc                 esp
            //   8985d0f0ffff         | mov                 byte ptr [esp + 0x60], dh
            //   85db                 | lea                 ecx, [ebp - 0xd9c]
            //   0f8482000000         | push                0xc7f
            //   6a3c                 | lea                 eax, [ebp - 0xd93]
            //   8d8554f0ffff         | mov                 esi, eax
            //   6a00                 | push                eax

        $sequence_1 = { 3dff000000 0f87c3020000 f685a8f7ffff10 0f844f010000 8b751c 3bf3 0f8444010000 }
            // n = 7, score = 200
            //   3dff000000           | lea                 ecx, [esp + 0x90]
            //   0f87c3020000         | dec                 eax
            //   f685a8f7ffff10       | mov                 ecx, 0x80000002
            //   0f844f010000         | dec                 eax
            //   8b751c               | mov                 dword ptr [esp + 0x20], eax
            //   3bf3                 | test                eax, eax
            //   0f8444010000         | jne                 0x11b

        $sequence_2 = { 83c40c 6803010000 8d8c2444030000 51 c744241400000000 ff15???????? 8b3d???????? }
            // n = 7, score = 200
            //   83c40c               | mov                 eax, 0x30b
            //   6803010000           | inc                 ebp
            //   8d8c2444030000       | movzx               eax, al
            //   51                   | inc                 esp
            //   c744241400000000     | mov                 dword ptr [esp + 0x30], edx
            //   ff15????????         |                     
            //   8b3d????????         |                     

        $sequence_3 = { 75f9 2bc1 7511 33c0 5e 8b4dfc 33cd }
            // n = 7, score = 200
            //   75f9                 | dec                 eax
            //   2bc1                 | lea                 ecx, [0x21d76]
            //   7511                 | mov                 dword ptr [esp + 0x40], 4
            //   33c0                 | dec                 ecx
            //   5e                   | mov                 ecx, esp
            //   8b4dfc               | xor                 eax, eax
            //   33cd                 | xor                 eax, eax

        $sequence_4 = { b9???????? 8bf0 e8???????? 50 8d9435f4feffff 68???????? 52 }
            // n = 7, score = 200
            //   b9????????           |                     
            //   8bf0                 | dec                 eax
            //   e8????????           |                     
            //   50                   | lea                 ecx, [ebp + 0xa1]
            //   8d9435f4feffff       | xor                 edx, edx
            //   68????????           |                     
            //   52                   | inc                 ecx

        $sequence_5 = { 8d8d64f2ffff e8???????? 687f0c0000 8d856df2ffff }
            // n = 4, score = 200
            //   8d8d64f2ffff         | dec                 ecx
            //   e8????????           |                     
            //   687f0c0000           | mov                 esi, eax
            //   8d856df2ffff         | movzx               edi, dl

        $sequence_6 = { 50 8d95f8feffff 52 e8???????? 83c408 85c0 }
            // n = 6, score = 200
            //   50                   | mov                 dword ptr [esp + 0x28], edx
            //   8d95f8feffff         | mov                 dword ptr [esp + 0x20], ecx
            //   52                   | dec                 eax
            //   e8????????           |                     
            //   83c408               | lea                 edx, [0x1d599]
            //   85c0                 | dec                 eax

        $sequence_7 = { 8bc6 c1f805 8d0c8560aa0310 8bc6 83e01f c1e006 8b11 }
            // n = 7, score = 200
            //   8bc6                 | lea                 edx, [ebp + esi - 0x10c]
            //   c1f805               | push                edx
            //   8d0c8560aa0310       | add                 esp, 0xc
            //   8bc6                 | push                0x103
            //   83e01f               | lea                 ecx, [esp + 0x344]
            //   c1e006               | push                ecx
            //   8b11                 | mov                 dword ptr [esp + 0x14], 0

        $sequence_8 = { 41b800040000 c684246002000000 e8???????? 488d8c2470060000 4c8bcf ba01000000 41b800040000 }
            // n = 7, score = 100
            //   41b800040000         | inc                 ecx
            //   c684246002000000     | mov                 eax, 0x400
            //   e8????????           |                     
            //   488d8c2470060000     | mov                 byte ptr [esp + 0x260], 0
            //   4c8bcf               | dec                 eax
            //   ba01000000           | lea                 ecx, [esp + 0x670]
            //   41b800040000         | dec                 esp

        $sequence_9 = { 48894c2450 498bf0 0fb6fa 488d8da1000000 33d2 41b80b030000 }
            // n = 6, score = 100
            //   48894c2450           | sar                 edx, 5
            //   498bf0               | dec                 esp
            //   0fb6fa               | lea                 eax, [0x24420]
            //   488d8da1000000       | mov                 eax, edx
            //   33d2                 | shr                 eax, 0x1f
            //   41b80b030000         | add                 edx, eax

        $sequence_10 = { 48c7c102000080 4889442420 ff15???????? 85c0 0f8513010000 488d0d761d0200 c744244004000000 }
            // n = 7, score = 100
            //   48c7c102000080       | dec                 ebp
            //   4889442420           | mov                 esp, eax
            //   ff15????????         |                     
            //   85c0                 | dec                 esp
            //   0f8513010000         | mov                 dword ptr [esp + 0x48], eax
            //   488d0d761d0200       | dec                 eax
            //   c744244004000000     | mov                 esi, edx

        $sequence_11 = { 488985400f0000 4c8bb5c00f0000 48894c2450 4d8be0 4c89442448 488bf2 488d8d31060000 }
            // n = 7, score = 100
            //   488985400f0000       | mov                 edx, eax
            //   4c8bb5c00f0000       | dec                 eax
            //   48894c2450           | lea                 ecx, [0x2086b]
            //   4d8be0               | dec                 eax
            //   4c89442448           | mov                 ecx, ebx
            //   488bf2               | inc                 ecx
            //   488d8d31060000       | imul                eax

        $sequence_12 = { 41f7e8 c1fa05 4c8d0520440200 8bc2 c1e81f 03d0 }
            // n = 6, score = 100
            //   41f7e8               | push                ebp
            //   c1fa05               | dec                 eax
            //   4c8d0520440200       | sub                 esp, 0x50
            //   8bc2                 | inc                 esp
            //   c1e81f               | mov                 ecx, edx
            //   03d0                 | dec                 eax

        $sequence_13 = { 488bd0 ff15???????? 488d0d6b080200 488905???????? e8???????? 488bcb }
            // n = 6, score = 100
            //   488bd0               | inc                 ecx
            //   ff15????????         |                     
            //   488d0d6b080200       | push                esp
            //   488905????????       |                     
            //   e8????????           |                     
            //   488bcb               | inc                 ecx

        $sequence_14 = { 53 55 56 4154 4155 4883ec50 448bca }
            // n = 7, score = 100
            //   53                   | mov                 ecx, edi
            //   55                   | mov                 edx, 1
            //   56                   | inc                 ecx
            //   4154                 | mov                 eax, 0x400
            //   4155                 | push                ebx
            //   4883ec50             | push                ebp
            //   448bca               | push                esi

        $sequence_15 = { 450fb6c0 4489542430 89542428 894c2420 488d1599d50100 488d8c2490000000 }
            // n = 6, score = 100
            //   450fb6c0             | dec                 eax
            //   4489542430           | mov                 dword ptr [ebp + 0xf40], eax
            //   89542428             | dec                 esp
            //   894c2420             | mov                 esi, dword ptr [ebp + 0xfc0]
            //   488d1599d50100       | dec                 eax
            //   488d8c2490000000     | mov                 dword ptr [esp + 0x50], ecx

    condition:
        7 of them and filesize < 524288
}