rule win_httpsuploader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.httpsuploader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.httpsuploader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 41b8fe010000 6689bdf0020000 e8???????? 488d8df2040000 }
            // n = 4, score = 100
            //   41b8fe010000         | mov                 byte ptr [ecx], al
            //   6689bdf0020000       | inc                 ecx
            //   e8????????           |                     
            //   488d8df2040000       | movzx               eax, bl

        $sequence_1 = { 33c0 488d4c2422 33d2 41b8fe010000 }
            // n = 4, score = 100
            //   33c0                 | mov                 byte ptr [esi + 2], al
            //   488d4c2422           | movzx               eax, byte ptr [eax + ebp]
            //   33d2                 | inc                 ecx
            //   41b8fe010000         | mov                 byte ptr [edx], al

        $sequence_2 = { 458d4103 ba00000080 c744242880000000 4c89ac2498040000 }
            // n = 4, score = 100
            //   458d4103             | lea                 edx, [ecx + 0x1b]
            //   ba00000080           | mov                 dword ptr [esp + 0x48], 0xf180
            //   c744242880000000     | mov                 eax, 1
            //   4c89ac2498040000     | inc                 ecx

        $sequence_3 = { 03df 3bde 72ad 488b5c2448 488b7c2420 b801000000 4883c428 }
            // n = 7, score = 100
            //   03df                 | mov                 byte ptr [edx], 0
            //   3bde                 | dec                 eax
            //   72ad                 | mov                 eax, edi
            //   488b5c2448           | dec                 eax
            //   488b7c2420           | test                esi, esi
            //   b801000000           | je                  0x351
            //   4883c428             | inc                 esp

        $sequence_4 = { ffca 750d 4d85c0 7408 498bc8 e8???????? }
            // n = 6, score = 100
            //   ffca                 | xor                 ecx, ecx
            //   750d                 | mov                 dword ptr [esp + 0x28], 3
            //   4d85c0               | dec                 eax
            //   7408                 | mov                 ebx, dword ptr [esp + 0x10]
            //   498bc8               | inc                 ecx
            //   e8????????           |                     

        $sequence_5 = { 40387598 e9???????? 48895c2408 4889742410 48897c2418 }
            // n = 5, score = 100
            //   40387598             | dec                 eax
            //   e9????????           |                     
            //   48895c2408           | arpl                cx, bx
            //   4889742410           | dec                 eax
            //   48897c2418           | lea                 edi, [0xa604]

        $sequence_6 = { 48897c2420 895c2440 895c2450 85d2 745e 6666660f1f840000000000 }
            // n = 6, score = 100
            //   48897c2420           | mov                 ah, byte ptr [eax]
            //   895c2440             | inc                 ebp
            //   895c2450             | test                ah, ah
            //   85d2                 | jne                 0xfffffa2b
            //   745e                 | inc                 esp
            //   6666660f1f840000000000     | cmp    byte ptr [ebp - 0x68], dl

        $sequence_7 = { e8???????? eb40 4c8d2569be0000 488b0d???????? e9???????? 4c8d2566be0000 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   eb40                 | mov                 dword ptr [esp + 0x48], ebx
            //   4c8d2569be0000       | xor                 ebx, ebx
            //   488b0d????????       |                     
            //   e9????????           |                     
            //   4c8d2566be0000       | dec                 eax

        $sequence_8 = { e8???????? 488d8de2000000 33d2 41b806020000 6689bde0000000 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   488d8de2000000       | dec                 eax
            //   33d2                 | mov                 dword ptr [esp + 0x10], ebx
            //   41b806020000         | dec                 eax
            //   6689bde0000000       | mov                 dword ptr [esp + 0x18], edi

        $sequence_9 = { 7528 48833d????????00 741e 488d0db1f40000 }
            // n = 4, score = 100
            //   7528                 | mov                 ecx, 0xa0000000
            //   48833d????????00     |                     
            //   741e                 | inc                 ecx
            //   488d0db1f40000       | or                  eax, 0xffffffff

    condition:
        7 of them and filesize < 190464
}