rule win_hunters_international_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hunters_international."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hunters_international"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c641040c e9???????? c641040d e9???????? }
            // n = 4, score = 400
            //   c641040c             | mov                 ecx, 1
            //   e9????????           |                     
            //   c641040d             | dec                 esp
            //   e9????????           |                     

        $sequence_1 = { e9???????? c641040d e9???????? c641040e e9???????? c641040f e9???????? }
            // n = 7, score = 400
            //   e9????????           |                     
            //   c641040d             | mov                 dword ptr [esp + 0x228], ecx
            //   e9????????           |                     
            //   c641040e             | dec                 eax
            //   e9????????           |                     
            //   c641040f             | mov                 dword ptr [esp + 0x230], 0
            //   e9????????           |                     

        $sequence_2 = { 241f 3c1f 750f c70100000000 c641041f }
            // n = 5, score = 400
            //   241f                 | movd                xmm0, ebp
            //   3c1f                 | mov                 edx, edi
            //   750f                 | mov                 ebx, ebp
            //   c70100000000         | and                 eax, esi
            //   c641041f             | add                 eax, ecx

        $sequence_3 = { c641040c e9???????? c641040d e9???????? c641040e }
            // n = 5, score = 400
            //   c641040c             | mov                 byte ptr [ecx + 4], 0
            //   e9????????           |                     
            //   c641040d             | mov                 dword ptr [edx + 0xc], eax
            //   e9????????           |                     
            //   c641040e             | lea                 esi, [esp + 0x1c]

        $sequence_4 = { c6410402 e9???????? c6410405 e9???????? c641040c e9???????? c641040d }
            // n = 7, score = 400
            //   c6410402             | test                eax, eax
            //   e9????????           |                     
            //   c6410405             | mov                 byte ptr [eax + 0x20], 0
            //   e9????????           |                     
            //   c641040c             | dec                 eax
            //   e9????????           |                     
            //   c641040d             | add                 esp, 0x28

        $sequence_5 = { c6410405 e9???????? c641040c e9???????? c641040d e9???????? }
            // n = 6, score = 400
            //   c6410405             | dec                 eax
            //   e9????????           |                     
            //   c641040c             | shl                 ecx, 5
            //   e9????????           |                     
            //   c641040d             | vmovdqa             ymmword ptr [esp + 0x180], ymm3
            //   e9????????           |                     

        $sequence_6 = { 750f c70100000000 c641041f c6410810 }
            // n = 4, score = 400
            //   750f                 | dec                 eax
            //   c70100000000         | add                 esp, 0x50
            //   c641041f             | pop                 esi
            //   c6410810             | jne                 0xfb

        $sequence_7 = { c6410400 e9???????? c6410402 e9???????? c6410405 }
            // n = 5, score = 400
            //   c6410400             | inc                 eax
            //   e9????????           |                     
            //   c6410402             | mov                 byte ptr [eax + 0x4d], dh
            //   e9????????           |                     
            //   c6410405             | inc                 ecx

        $sequence_8 = { c6410402 e9???????? c6410405 e9???????? }
            // n = 4, score = 400
            //   c6410402             | lea                 eax, [0x29d8a]
            //   e9????????           |                     
            //   c6410405             | ret                 
            //   e9????????           |                     

        $sequence_9 = { c641040c e9???????? c641040d e9???????? c641040e e9???????? }
            // n = 6, score = 400
            //   c641040c             | add                 byte ptr [eax], al
            //   e9????????           |                     
            //   c641040d             | jne                 0xffffffc2
            //   e9????????           |                     
            //   c641040e             | mov                 byte ptr [eax], 0
            //   e9????????           |                     

    condition:
        7 of them and filesize < 1377280
}