rule win_ice_event_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ice_event."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ice_event"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48c74424780f000000 c644246000 488b4598 4883f810 }
            // n = 4, score = 100
            //   48c74424780f000000     | test    eax, eax
            //   c644246000           | je                  0x4b7
            //   488b4598             | dec                 eax
            //   4883f810             | lea                 edx, [0x1ba80]

        $sequence_1 = { 3b0d???????? 7326 4863c9 488d15b4080100 488bc1 83e13f }
            // n = 6, score = 100
            //   3b0d????????         |                     
            //   7326                 | dec                 eax
            //   4863c9               | mov                 edx, ebx
            //   488d15b4080100       | dec                 eax
            //   488bc1               | lea                 ecx, [0x1dd6f]
            //   83e13f               | xor                 ecx, ecx

        $sequence_2 = { 48c743180f000000 c60300 8bc6 488b4c2478 4833cc e8???????? 4c8d9c2480000000 }
            // n = 7, score = 100
            //   48c743180f000000     | dec                 eax
            //   c60300               | lea                 eax, [0xaed9]
            //   8bc6                 | dec                 eax
            //   488b4c2478           | mov                 dword ptr [ebp + 0xf], eax
            //   4833cc               | dec                 eax
            //   e8????????           |                     
            //   4c8d9c2480000000     | lea                 eax, [0xaede]

        $sequence_3 = { 4863f8 4803f7 4983c9ff 4c8bc7 488d542430 488d4dc8 }
            // n = 6, score = 100
            //   4863f8               | dec                 esp
            //   4803f7               | sub                 eax, ecx
            //   4983c9ff             | dec                 eax
            //   4c8bc7               | sub                 esi, ebp
            //   488d542430           | dec                 esp
            //   488d4dc8             | lea                 esi, [esi + esi]

        $sequence_4 = { 4156 4883ec28 488b4210 498bf9 498bf0 }
            // n = 5, score = 100
            //   4156                 | test                byte ptr [eax + esi + 0x38], 0x40
            //   4883ec28             | dec                 eax
            //   488b4210             | lea                 ecx, [0x1df3c]
            //   498bf9               | test                eax, eax
            //   498bf0               | dec                 eax

        $sequence_5 = { 660f28d1 660f28c1 4c8d0d8b9f0000 f20f101d???????? f20f100d???????? }
            // n = 5, score = 100
            //   660f28d1             | mov                 dword ptr [eax + 0x10], esi
            //   660f28c1             | dec                 eax
            //   4c8d0d8b9f0000       | lea                 ebp, [esp - 0x1070]
            //   f20f101d????????     |                     
            //   f20f100d????????     |                     

        $sequence_6 = { 488bcb 4a8d1441 482bf5 4c8d3436 }
            // n = 4, score = 100
            //   488bcb               | jb                  0x524
            //   4a8d1441             | dec                 eax
            //   482bf5               | cmp                 ecx, 0x27
            //   4c8d3436             | ja                  0x51e

        $sequence_7 = { 4833cc e8???????? 488b9c24a0110000 4881c470110000 5f }
            // n = 5, score = 100
            //   4833cc               | je                  0x1c4
            //   e8????????           |                     
            //   488b9c24a0110000     | dec                 eax
            //   4881c470110000       | cmp                 dword ptr [ebx + 0x18], 8
            //   5f                   | jb                  0x128

        $sequence_8 = { 8bce 894d30 8bc6 894538 ffc3 83fb3c 0f8c6cffffff }
            // n = 7, score = 100
            //   8bce                 | mov                 dword ptr [esp + 0x48], 0xf
            //   894d30               | mov                 byte ptr [esp + 0x30], 0
            //   8bc6                 | dec                 ecx
            //   894538               | or                  ecx, 0xffffffff
            //   ffc3                 | inc                 ebp
            //   83fb3c               | xor                 eax, eax
            //   0f8c6cffffff         | test                eax, eax

        $sequence_9 = { 488bce e8???????? eb55 4c896d68 48c745700f000000 }
            // n = 5, score = 100
            //   488bce               | dec                 eax
            //   e8????????           |                     
            //   eb55                 | mov                 ecx, dword ptr [ecx]
            //   4c896d68             | dec                 eax
            //   48c745700f000000     | mov                 ecx, dword ptr [ecx]

    condition:
        7 of them and filesize < 331776
}