rule win_ice_ix_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ice_ix."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ice_ix"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 56 6a47 8945f0 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   56                   | push                esi
            //   6a47                 | push                0x47
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax

        $sequence_1 = { 8db508ffffff 58 e8???????? 6a63 8d7598 58 e8???????? }
            // n = 7, score = 200
            //   8db508ffffff         | lea                 esi, [ebp - 0xf8]
            //   58                   | pop                 eax
            //   e8????????           |                     
            //   6a63                 | push                0x63
            //   8d7598               | lea                 esi, [ebp - 0x68]
            //   58                   | pop                 eax
            //   e8????????           |                     

        $sequence_2 = { 6a08 6a00 8d45f4 50 e8???????? 8db5d8feffff b89b000000 }
            // n = 7, score = 200
            //   6a08                 | push                8
            //   6a00                 | push                0
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8db5d8feffff         | lea                 esi, [ebp - 0x128]
            //   b89b000000           | mov                 eax, 0x9b

        $sequence_3 = { 6a2d 58 e8???????? ff75d0 ff15???????? }
            // n = 5, score = 200
            //   6a2d                 | push                0x2d
            //   58                   | pop                 eax
            //   e8????????           |                     
            //   ff75d0               | push                dword ptr [ebp - 0x30]
            //   ff15????????         |                     

        $sequence_4 = { 85ff 0f8403020000 8a1408 80fa0d }
            // n = 4, score = 200
            //   85ff                 | test                edi, edi
            //   0f8403020000         | je                  0x209
            //   8a1408               | mov                 dl, byte ptr [eax + ecx]
            //   80fa0d               | cmp                 dl, 0xd

        $sequence_5 = { 833d????????04 8b7c2414 1bc0 f7d8 68cc000000 83c034 e8???????? }
            // n = 7, score = 200
            //   833d????????04       |                     
            //   8b7c2414             | mov                 edi, dword ptr [esp + 0x14]
            //   1bc0                 | sbb                 eax, eax
            //   f7d8                 | neg                 eax
            //   68cc000000           | push                0xcc
            //   83c034               | add                 eax, 0x34
            //   e8????????           |                     

        $sequence_6 = { 6a3f 8d75b8 58 e8???????? 8b4df4 8bc6 50 }
            // n = 7, score = 200
            //   6a3f                 | push                0x3f
            //   8d75b8               | lea                 esi, [ebp - 0x48]
            //   58                   | pop                 eax
            //   e8????????           |                     
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   8bc6                 | mov                 eax, esi
            //   50                   | push                eax

        $sequence_7 = { c20400 55 8bec 83ec20 56 6a5c }
            // n = 6, score = 200
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec20               | sub                 esp, 0x20
            //   56                   | push                esi
            //   6a5c                 | push                0x5c

        $sequence_8 = { 741d 48 7416 83e80b 740d 83e805 7404 }
            // n = 7, score = 200
            //   741d                 | je                  0x1f
            //   48                   | dec                 eax
            //   7416                 | je                  0x18
            //   83e80b               | sub                 eax, 0xb
            //   740d                 | je                  0xf
            //   83e805               | sub                 eax, 5
            //   7404                 | je                  6

        $sequence_9 = { 57 ff15???????? 8b4640 3bc3 0f84a8000000 6800000010 68254e0000 }
            // n = 7, score = 200
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8b4640               | mov                 eax, dword ptr [esi + 0x40]
            //   3bc3                 | cmp                 eax, ebx
            //   0f84a8000000         | je                  0xae
            //   6800000010           | push                0x10000000
            //   68254e0000           | push                0x4e25

    condition:
        7 of them and filesize < 327680
}