rule win_icedid_downloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.icedid_downloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.icedid_downloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bf0 8944241c 8d442408 50 6a08 6aff 885c241c }
            // n = 7, score = 400
            //   8bf0                 | mov                 esi, eax
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   8d442408             | lea                 eax, [esp + 8]
            //   50                   | push                eax
            //   6a08                 | push                8
            //   6aff                 | push                -1
            //   885c241c             | mov                 byte ptr [esp + 0x1c], bl

        $sequence_1 = { 56 6a02 ff74241c ffd7 ff15???????? 83f87a 0f85e9000000 }
            // n = 7, score = 400
            //   56                   | push                esi
            //   6a02                 | push                2
            //   ff74241c             | push                dword ptr [esp + 0x1c]
            //   ffd7                 | call                edi
            //   ff15????????         |                     
            //   83f87a               | cmp                 eax, 0x7a
            //   0f85e9000000         | jne                 0xef

        $sequence_2 = { 8bf0 e8???????? 85f6 740c 8b4508 3b07 }
            // n = 6, score = 400
            //   8bf0                 | mov                 esi, eax
            //   e8????????           |                     
            //   85f6                 | test                esi, esi
            //   740c                 | je                  0xe
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   3b07                 | cmp                 eax, dword ptr [edi]

        $sequence_3 = { 83e801 740a 83e801 751c 80cb01 }
            // n = 5, score = 400
            //   83e801               | sub                 eax, 1
            //   740a                 | je                  0xc
            //   83e801               | sub                 eax, 1
            //   751c                 | jne                 0x1e
            //   80cb01               | or                  bl, 1

        $sequence_4 = { 56 68000000c0 ff7510 ff15???????? }
            // n = 4, score = 400
            //   56                   | push                esi
            //   68000000c0           | push                0xc0000000
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ff15????????         |                     

        $sequence_5 = { 8d442428 50 ff742438 ff15???????? 8d442440 50 68???????? }
            // n = 7, score = 400
            //   8d442428             | lea                 eax, [esp + 0x28]
            //   50                   | push                eax
            //   ff742438             | push                dword ptr [esp + 0x38]
            //   ff15????????         |                     
            //   8d442440             | lea                 eax, [esp + 0x40]
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_6 = { 7821 395df8 741c 6a04 8d45f8 }
            // n = 5, score = 400
            //   7821                 | js                  0x23
            //   395df8               | cmp                 dword ptr [ebp - 8], ebx
            //   741c                 | je                  0x1e
            //   6a04                 | push                4
            //   8d45f8               | lea                 eax, [ebp - 8]

        $sequence_7 = { 8b08 50 ff5114 85c0 7404 33c0 }
            // n = 6, score = 400
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   50                   | push                eax
            //   ff5114               | call                dword ptr [ecx + 0x14]
            //   85c0                 | test                eax, eax
            //   7404                 | je                  6
            //   33c0                 | xor                 eax, eax

        $sequence_8 = { 8b442418 8d542430 59 59 56 8b08 }
            // n = 6, score = 400
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   8d542430             | lea                 edx, [esp + 0x30]
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   56                   | push                esi
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_9 = { 896c241c 896c240c 896c2420 896c2438 895c2434 ff15???????? }
            // n = 6, score = 400
            //   896c241c             | mov                 dword ptr [esp + 0x1c], ebp
            //   896c240c             | mov                 dword ptr [esp + 0xc], ebp
            //   896c2420             | mov                 dword ptr [esp + 0x20], ebp
            //   896c2438             | mov                 dword ptr [esp + 0x38], ebp
            //   895c2434             | mov                 dword ptr [esp + 0x34], ebx
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 40960
}