rule win_icondown_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.icondown."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.icondown"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 8b4608 8d542414 52 }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   8d542414             | lea                 edx, [esp + 0x14]
            //   52                   | push                edx

        $sequence_1 = { 8bcf e8???????? 85c0 7415 8b4c2418 8b10 }
            // n = 6, score = 200
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7415                 | je                  0x17
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]
            //   8b10                 | mov                 edx, dword ptr [eax]

        $sequence_2 = { c7466c01000000 8b4b1c 51 ff15???????? 5f 5e 5d }
            // n = 7, score = 200
            //   c7466c01000000       | mov                 dword ptr [esi + 0x6c], 1
            //   8b4b1c               | mov                 ecx, dword ptr [ebx + 0x1c]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp

        $sequence_3 = { e8???????? 8d966c020000 52 68e9030000 57 e8???????? 8d8670020000 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8d966c020000         | lea                 edx, [esi + 0x26c]
            //   52                   | push                edx
            //   68e9030000           | push                0x3e9
            //   57                   | push                edi
            //   e8????????           |                     
            //   8d8670020000         | lea                 eax, [esi + 0x270]

        $sequence_4 = { 8b8690000000 8b48f8 85c9 740d 8b4e64 50 51 }
            // n = 7, score = 200
            //   8b8690000000         | mov                 eax, dword ptr [esi + 0x90]
            //   8b48f8               | mov                 ecx, dword ptr [eax - 8]
            //   85c9                 | test                ecx, ecx
            //   740d                 | je                  0xf
            //   8b4e64               | mov                 ecx, dword ptr [esi + 0x64]
            //   50                   | push                eax
            //   51                   | push                ecx

        $sequence_5 = { 894e54 8b15???????? 895658 a1???????? 89465c 8b0d???????? }
            // n = 6, score = 200
            //   894e54               | mov                 dword ptr [esi + 0x54], ecx
            //   8b15????????         |                     
            //   895658               | mov                 dword ptr [esi + 0x58], edx
            //   a1????????           |                     
            //   89465c               | mov                 dword ptr [esi + 0x5c], eax
            //   8b0d????????         |                     

        $sequence_6 = { 46 f680c11c450004 741c 837d1000 }
            // n = 4, score = 200
            //   46                   | inc                 esi
            //   f680c11c450004       | test                byte ptr [eax + 0x451cc1], 4
            //   741c                 | je                  0x1e
            //   837d1000             | cmp                 dword ptr [ebp + 0x10], 0

        $sequence_7 = { 895658 a1???????? 89465c 8b0d???????? 894e60 8b15???????? 895664 }
            // n = 7, score = 200
            //   895658               | mov                 dword ptr [esi + 0x58], edx
            //   a1????????           |                     
            //   89465c               | mov                 dword ptr [esi + 0x5c], eax
            //   8b0d????????         |                     
            //   894e60               | mov                 dword ptr [esi + 0x60], ecx
            //   8b15????????         |                     
            //   895664               | mov                 dword ptr [esi + 0x64], edx

        $sequence_8 = { 52 8b481c 51 ff15???????? 8b442404 6a01 }
            // n = 6, score = 200
            //   52                   | push                edx
            //   8b481c               | mov                 ecx, dword ptr [eax + 0x1c]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   6a01                 | push                1

        $sequence_9 = { 740d 8b01 6a01 ff10 8b4e10 }
            // n = 5, score = 200
            //   740d                 | je                  0xf
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   6a01                 | push                1
            //   ff10                 | call                dword ptr [eax]
            //   8b4e10               | mov                 ecx, dword ptr [esi + 0x10]

    condition:
        7 of them and filesize < 5505024
}