rule win_iisniff_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.iisniff."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.iisniff"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b8c240c000100 56 8d842414000100 50 51 8d542410 52 }
            // n = 7, score = 200
            //   8b8c240c000100       | mov                 ecx, dword ptr [esp + 0x1000c]
            //   56                   | push                esi
            //   8d842414000100       | lea                 eax, [esp + 0x10014]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8d542410             | lea                 edx, [esp + 0x10]
            //   52                   | push                edx

        $sequence_1 = { 7413 0fb7542418 8b44241c 50 89570c ff15???????? 8b4f60 }
            // n = 7, score = 200
            //   7413                 | je                  0x15
            //   0fb7542418           | movzx               edx, word ptr [esp + 0x18]
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   50                   | push                eax
            //   89570c               | mov                 dword ptr [edi + 0xc], edx
            //   ff15????????         |                     
            //   8b4f60               | mov                 ecx, dword ptr [edi + 0x60]

        $sequence_2 = { 51 89742478 e8???????? 8b8c2450010000 83c404 5f }
            // n = 6, score = 200
            //   51                   | push                ecx
            //   89742478             | mov                 dword ptr [esp + 0x78], esi
            //   e8????????           |                     
            //   8b8c2450010000       | mov                 ecx, dword ptr [esp + 0x150]
            //   83c404               | add                 esp, 4
            //   5f                   | pop                 edi

        $sequence_3 = { e8???????? 8b550c 8b02 89450c 3b35???????? 7442 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   89450c               | mov                 dword ptr [ebp + 0xc], eax
            //   3b35????????         |                     
            //   7442                 | je                  0x44

        $sequence_4 = { 83c710 e8???????? 59 8b4c2414 50 56 6a03 }
            // n = 7, score = 200
            //   83c710               | add                 edi, 0x10
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   50                   | push                eax
            //   56                   | push                esi
            //   6a03                 | push                3

        $sequence_5 = { 8bc7 c20400 55 8bec 56 57 8b7d08 }
            // n = 7, score = 200
            //   8bc7                 | mov                 eax, edi
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]

        $sequence_6 = { 6a00 e8???????? c745fcffffffff 8b45dc 8b08 8b5104 8b440228 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   e8????????           |                     
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8b5104               | mov                 edx, dword ptr [ecx + 4]
            //   8b440228             | mov                 eax, dword ptr [edx + eax + 0x28]

        $sequence_7 = { 8d8424d0010000 50 89442430 e8???????? }
            // n = 4, score = 200
            //   8d8424d0010000       | lea                 eax, [esp + 0x1d0]
            //   50                   | push                eax
            //   89442430             | mov                 dword ptr [esp + 0x30], eax
            //   e8????????           |                     

        $sequence_8 = { 037dbc 8d5d94 8d75d4 e8???????? 8bf0 e8???????? 8b4dcc }
            // n = 7, score = 200
            //   037dbc               | add                 edi, dword ptr [ebp - 0x44]
            //   8d5d94               | lea                 ebx, [ebp - 0x6c]
            //   8d75d4               | lea                 esi, [ebp - 0x2c]
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   e8????????           |                     
            //   8b4dcc               | mov                 ecx, dword ptr [ebp - 0x34]

        $sequence_9 = { 52 8d842434010000 50 8d4c2420 }
            // n = 4, score = 200
            //   52                   | push                edx
            //   8d842434010000       | lea                 eax, [esp + 0x134]
            //   50                   | push                eax
            //   8d4c2420             | lea                 ecx, [esp + 0x20]

        $sequence_10 = { 6a03 68000000c0 68???????? ff15???????? 6a02 }
            // n = 5, score = 200
            //   6a03                 | push                3
            //   68000000c0           | push                0xc0000000
            //   68????????           |                     
            //   ff15????????         |                     
            //   6a02                 | push                2

        $sequence_11 = { 837d1000 57 8bf9 7e5f 53 8b5d08 56 }
            // n = 7, score = 200
            //   837d1000             | cmp                 dword ptr [ebp + 0x10], 0
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx
            //   7e5f                 | jle                 0x61
            //   53                   | push                ebx
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   56                   | push                esi

        $sequence_12 = { 6a02 e8???????? 83bc24f000000010 8b8424dc000000 7307 8d8424dc000000 ffb424ec000000 }
            // n = 7, score = 200
            //   6a02                 | push                2
            //   e8????????           |                     
            //   83bc24f000000010     | cmp                 dword ptr [esp + 0xf0], 0x10
            //   8b8424dc000000       | mov                 eax, dword ptr [esp + 0xdc]
            //   7307                 | jae                 9
            //   8d8424dc000000       | lea                 eax, [esp + 0xdc]
            //   ffb424ec000000       | push                dword ptr [esp + 0xec]

        $sequence_13 = { 59 5e 5b 8b8c243c010000 33cc e8???????? }
            // n = 6, score = 200
            //   59                   | pop                 ecx
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   8b8c243c010000       | mov                 ecx, dword ptr [esp + 0x13c]
            //   33cc                 | xor                 ecx, esp
            //   e8????????           |                     

        $sequence_14 = { 8b7d08 33db 68ff0f0000 8d8424cd000000 53 50 889c24d4000000 }
            // n = 7, score = 200
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   33db                 | xor                 ebx, ebx
            //   68ff0f0000           | push                0xfff
            //   8d8424cd000000       | lea                 eax, [esp + 0xcd]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   889c24d4000000       | mov                 byte ptr [esp + 0xd4], bl

    condition:
        7 of them and filesize < 1441792
}