rule win_iispy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.iispy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.iispy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 837c242400 8bf8 740c ff742428 e8???????? 83c404 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   837c242400           | cmp                 dword ptr [esp + 0x24], 0
            //   8bf8                 | mov                 edi, eax
            //   740c                 | je                  0xe
            //   ff742428             | push                dword ptr [esp + 0x28]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_1 = { 03d8 eb49 b8d34d6210 f7e3 8bca 8b5514 c1e906 }
            // n = 7, score = 100
            //   03d8                 | add                 ebx, eax
            //   eb49                 | jmp                 0x4b
            //   b8d34d6210           | mov                 eax, 0x10624dd3
            //   f7e3                 | mul                 ebx
            //   8bca                 | mov                 ecx, edx
            //   8b5514               | mov                 edx, dword ptr [ebp + 0x14]
            //   c1e906               | shr                 ecx, 6

        $sequence_2 = { 50 8d4110 50 8d4129 50 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   8d4110               | lea                 eax, [ecx + 0x10]
            //   50                   | push                eax
            //   8d4129               | lea                 eax, [ecx + 0x29]
            //   50                   | push                eax

        $sequence_3 = { 8b048528cf0210 0fb6440828 83e040 5d c3 e8???????? c70009000000 }
            // n = 7, score = 100
            //   8b048528cf0210       | mov                 eax, dword ptr [eax*4 + 0x1002cf28]
            //   0fb6440828           | movzx               eax, byte ptr [eax + ecx + 0x28]
            //   83e040               | and                 eax, 0x40
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   e8????????           |                     
            //   c70009000000         | mov                 dword ptr [eax], 9

        $sequence_4 = { 84c0 0f8429010000 8b4c2408 83c620 8b01 c1e005 }
            // n = 6, score = 100
            //   84c0                 | test                al, al
            //   0f8429010000         | je                  0x12f
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]
            //   83c620               | add                 esi, 0x20
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   c1e005               | shl                 eax, 5

        $sequence_5 = { b81f85eb51 f7eb 5f c1fa05 8bca c1e91f 03ca }
            // n = 7, score = 100
            //   b81f85eb51           | mov                 eax, 0x51eb851f
            //   f7eb                 | imul                ebx
            //   5f                   | pop                 edi
            //   c1fa05               | sar                 edx, 5
            //   8bca                 | mov                 ecx, edx
            //   c1e91f               | shr                 ecx, 0x1f
            //   03ca                 | add                 ecx, edx

        $sequence_6 = { 6a01 53 ff15???????? ebe0 b80d000780 5f 5e }
            // n = 7, score = 100
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   ebe0                 | jmp                 0xffffffe2
            //   b80d000780           | mov                 eax, 0x8007000d
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_7 = { 68000000c0 57 ff15???????? 8bf8 83ffff 74c5 8b4dec }
            // n = 7, score = 100
            //   68000000c0           | push                0xc0000000
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   83ffff               | cmp                 edi, -1
            //   74c5                 | je                  0xffffffc7
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]

        $sequence_8 = { 3245f0 32ec 3245e4 3245e0 3245e8 3245d0 3245ff }
            // n = 7, score = 100
            //   3245f0               | xor                 al, byte ptr [ebp - 0x10]
            //   32ec                 | xor                 ch, ah
            //   3245e4               | xor                 al, byte ptr [ebp - 0x1c]
            //   3245e0               | xor                 al, byte ptr [ebp - 0x20]
            //   3245e8               | xor                 al, byte ptr [ebp - 0x18]
            //   3245d0               | xor                 al, byte ptr [ebp - 0x30]
            //   3245ff               | xor                 al, byte ptr [ebp - 1]

        $sequence_9 = { 50 e8???????? 83a628cf021000 59 83c604 81fe00020000 72dd }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83a628cf021000       | and                 dword ptr [esi + 0x1002cf28], 0
            //   59                   | pop                 ecx
            //   83c604               | add                 esi, 4
            //   81fe00020000         | cmp                 esi, 0x200
            //   72dd                 | jb                  0xffffffdf

    condition:
        7 of them and filesize < 397312
}