rule win_imprudentcook_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.imprudentcook."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.imprudentcook"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 49f7d0 48c1ef20 498bc0 48897c2420 48f7f7 488bc8 }
            // n = 6, score = 100
            //   49f7d0               | js                  0x4d7
            //   48c1ef20             | dec                 eax
            //   498bc0               | mov                 dword ptr [esp + 0x20], ebx
            //   48897c2420           | inc                 ecx
            //   48f7f7               | call                edi
            //   488bc8               | xor                 eax, eax

        $sequence_1 = { 4981fd541f0000 7c24 488d0c5b 4881f9aa0f0000 7c17 488bcf 48895c2420 }
            // n = 7, score = 100
            //   4981fd541f0000       | add                 ecx, ebx
            //   7c24                 | dec                 eax
            //   488d0c5b             | mov                 dword ptr [edx], ecx
            //   4881f9aa0f0000       | dec                 eax
            //   7c17                 | cmp                 ecx, eax
            //   488bcf               | jae                 0x2a4
            //   48895c2420           | nop                 

        $sequence_2 = { 4c8d45f8 488d550f 488d4de7 4889442420 e8???????? 488d4d1f ff15???????? }
            // n = 7, score = 100
            //   4c8d45f8             | mov                 dword ptr [esp + 0x20], esi
            //   488d550f             | dec                 eax
            //   488d4de7             | mov                 ecx, dword ptr [eax]
            //   4889442420           | jmp                 0x361
            //   e8????????           |                     
            //   488d4d1f             | dec                 eax
            //   ff15????????         |                     

        $sequence_3 = { 7303 4d03d7 488bca 48c1ea20 418bc3 48c1e120 4803c8 }
            // n = 7, score = 100
            //   7303                 | mov                 ecx, esi
            //   4d03d7               | dec                 eax
            //   488bca               | mov                 edx, dword ptr [esp + 0x50]
            //   48c1ea20             | dec                 eax
            //   418bc3               | mov                 dword ptr [esp + 0x20], eax
            //   48c1e120             | dec                 eax
            //   4803c8               | add                 ecx, edi

        $sequence_4 = { 4c8bc7 498bd7 488bce 4889442420 e8???????? eb10 488bf5 }
            // n = 7, score = 100
            //   4c8bc7               | sub                 ecx, ebp
            //   498bd7               | je                  0x1618
            //   488bce               | dec                 eax
            //   4889442420           | mov                 dword ptr [ebx + ebp*8 - 8], eax
            //   e8????????           |                     
            //   eb10                 | jne                 0x15d9
            //   488bf5               | dec                 eax

        $sequence_5 = { 488d55e7 483bc1 498bca 7d12 488b45df 4c894c2428 4d8bc8 }
            // n = 7, score = 100
            //   488d55e7             | mov                 ecx, dword ptr [ecx]
            //   483bc1               | dec                 ecx
            //   498bca               | mov                 ebp, eax
            //   7d12                 | dec                 esp
            //   488b45df             | mov                 esp, edx
            //   4c894c2428           | dec                 eax
            //   4d8bc8               | mov                 ebx, ecx

        $sequence_6 = { 458bda 488bd0 4885c0 783d 482bc7 498d0cc4 498bc5 }
            // n = 7, score = 100
            //   458bda               | lea                 eax, [ecx + eax - 1]
            //   488bd0               | dec                 eax
            //   4885c0               | cdq                 
            //   783d                 | dec                 eax
            //   482bc7               | idiv                ecx
            //   498d0cc4             | dec                 ecx
            //   498bc5               | mov                 edx, edx

        $sequence_7 = { 493b45f0 752b 4883c8ff 498bd5 498bce 492bd7 492bcf }
            // n = 7, score = 100
            //   493b45f0             | dec                 esi
            //   752b                 | mov                 edx, dword ptr [edi + ecx]
            //   4883c8ff             | dec                 ebp
            //   498bd5               | mov                 eax, dword ptr [ecx]
            //   498bce               | dec                 ecx
            //   492bd7               | add                 ecx, 8
            //   492bcf               | inc                 ebp

        $sequence_8 = { 4d892cc4 4f8d2cfc 4c8bcf 4d8bc5 498bd4 e8???????? 488bdf }
            // n = 7, score = 100
            //   4d892cc4             | dec                 esp
            //   4f8d2cfc             | mov                 eax, dword ptr [esi + ebx*8]
            //   4c8bcf               | dec                 ecx
            //   4d8bc5               | mov                 edx, dword ptr [ebp]
            //   498bd4               | dec                 eax
            //   e8????????           |                     
            //   488bdf               | mov                 dword ptr [esp + 0x88], ebp

        $sequence_9 = { 488b8424a0000000 4d8bc4 4889442420 e8???????? 4883c450 415f 415e }
            // n = 7, score = 100
            //   488b8424a0000000     | mov                 dword ptr [esp + 0x28], ecx
            //   4d8bc4               | dec                 eax
            //   4889442420           | add                 esp, 0x30
            //   e8????????           |                     
            //   4883c450             | pop                 ebx
            //   415f                 | ret                 
            //   415e                 | dec                 eax

    condition:
        7 of them and filesize < 864256
}