rule win_industrial_spy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.industrial_spy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.industrial_spy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 03c8 43890c26 3bc8 7302 ffc7 037c242c }
            // n = 6, score = 100
            //   03c8                 | mov                 edx, ebp
            //   43890c26             | dec                 eax
            //   3bc8                 | mov                 ecx, edi
            //   7302                 | dec                 eax
            //   ffc7                 | mov                 dword ptr [esp + 0x20], ebx
            //   037c242c             | dec                 esp

        $sequence_1 = { 33c9 ff15???????? 8b15???????? 4c8d0577020200 498904d0 ffc2 8915???????? }
            // n = 7, score = 100
            //   33c9                 | ror                 eax, 0xb
            //   ff15????????         |                     
            //   8b15????????         |                     
            //   4c8d0577020200       | inc                 ecx
            //   498904d0             | add                 eax, dword ptr [ecx + 4]
            //   ffc2                 | add                 eax, ecx
            //   8915????????         |                     

        $sequence_2 = { 418bd9 498bf8 8bf2 4c8d0d2d9c0000 488be9 4c8d051b9c0000 }
            // n = 6, score = 100
            //   418bd9               | mov                 dword ptr [esp + 0x28], eax
            //   498bf8               | dec                 esp
            //   8bf2                 | lea                 eax, [0xffffead2]
            //   4c8d0d2d9c0000       | dec                 esp
            //   488be9               | mov                 ecx, ebx
            //   4c8d051b9c0000       | dec                 eax

        $sequence_3 = { 4403d3 41c1ca0c 4503d1 4133c2 054239faff 0345d4 03d0 }
            // n = 7, score = 100
            //   4403d3               | mov                 esp, ecx
            //   41c1ca0c             | dec                 esp
            //   4503d1               | mov                 edi, edx
            //   4133c2               | dec                 eax
            //   054239faff           | lea                 ecx, [ebp - 0x40]
            //   0345d4               | dec                 esp
            //   03d0                 | mov                 esi, dword ptr [ebp + 0x580]

        $sequence_4 = { 8bc1 488bce 4803d0 e8???????? 33c0 eb0c b801040000 }
            // n = 7, score = 100
            //   8bc1                 | jmp                 0x1b49
            //   488bce               | cmp                 eax, 1
            //   4803d0               | jne                 0x1dba
            //   e8????????           |                     
            //   33c0                 | inc                 ecx
            //   eb0c                 | mov                 eax, 0x400
            //   b801040000           | add                 eax, -2

        $sequence_5 = { 442bc9 f7d1 443bc9 418bc0 0f46d6 c1e010 }
            // n = 6, score = 100
            //   442bc9               | xchg                dword ptr [edi + esi*8 + 0x23fe8], eax
            //   f7d1                 | dec                 eax
            //   443bc9               | test                eax, eax
            //   418bc0               | je                  0x1bf0
            //   0f46d6               | dec                 eax
            //   c1e010               | mov                 ecx, ebx

        $sequence_6 = { 0345c0 418d91442229f4 03d0 448d8997ff2a43 418bc2 c1c206 f7d0 }
            // n = 7, score = 100
            //   0345c0               | inc                 esp
            //   418d91442229f4       | add                 edx, ecx
            //   03d0                 | inc                 ecx
            //   448d8997ff2a43       | mov                 ecx, eax
            //   418bc2               | not                 ecx
            //   c1c206               | inc                 ecx
            //   f7d0                 | ror                 edx, 0xc

        $sequence_7 = { 418d4a01 418bc1 c1e810 03c2 }
            // n = 4, score = 100
            //   418d4a01             | and                 ecx, ebx
            //   418bc1               | or                  ecx, eax
            //   c1e810               | inc                 esp
            //   03c2                 | lea                 ebx, [edx - 0xa83f051]

        $sequence_8 = { 33c0 eb3d 452bd3 4533c0 4585c9 742f 482bf9 }
            // n = 7, score = 100
            //   33c0                 | inc                 edx
            //   eb3d                 | mov                 byte ptr [esp + edx], al
            //   452bd3               | dec                 ecx
            //   4533c0               | inc                 edx
            //   4585c9               | dec                 ecx
            //   742f                 | cmp                 edx, 0x38
            //   482bf9               | jl                  0x12ad

        $sequence_9 = { 488d0d4bf40000 48894b48 4963d0 c6435401 e8???????? eb18 4885c9 }
            // n = 7, score = 100
            //   488d0d4bf40000       | mov                 eax, edx
            //   48894b48             | dec                 esp
            //   4963d0               | arpl                ax, ax
            //   c6435401             | test                eax, eax
            //   e8????????           |                     
            //   eb18                 | jle                 0x1449
            //   4885c9               | inc                 ecx

    condition:
        7 of them and filesize < 339968
}