rule win_industroyer2_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.industroyer2."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.industroyer2"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4dfc 8b11 c6420603 8b45fc 8b08 c6410783 8b55fc }
            // n = 7, score = 100
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   c6420603             | mov                 byte ptr [edx + 6], 3
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   c6410783             | mov                 byte ptr [ecx + 7], 0x83
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]

        $sequence_1 = { ebcc 8b4508 8b8848010100 8b55f4 }
            // n = 4, score = 100
            //   ebcc                 | jmp                 0xffffffce
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b8848010100         | mov                 ecx, dword ptr [eax + 0x10148]
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]

        $sequence_2 = { 894a0c 8b55f8 8b02 8b4d20 8b5108 895008 8b45f8 }
            // n = 7, score = 100
            //   894a0c               | mov                 dword ptr [edx + 0xc], ecx
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   8b4d20               | mov                 ecx, dword ptr [ebp + 0x20]
            //   8b5108               | mov                 edx, dword ptr [ecx + 8]
            //   895008               | mov                 dword ptr [eax + 8], edx
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_3 = { 8b4508 8945fc 8b4d0c 894df8 837d0800 7414 }
            // n = 6, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   7414                 | je                  0x16

        $sequence_4 = { e8???????? 83c404 85c0 7636 68???????? 8b4508 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   7636                 | jbe                 0x38
            //   68????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_5 = { 52 e8???????? 8b4508 83780800 }
            // n = 4, score = 100
            //   52                   | push                edx
            //   e8????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   83780800             | cmp                 dword ptr [eax + 8], 0

        $sequence_6 = { 694d18a0860100 034d1c 8b55fc 894a14 8b45fc 8be5 }
            // n = 6, score = 100
            //   694d18a0860100       | imul                ecx, dword ptr [ebp + 0x18], 0x186a0
            //   034d1c               | add                 ecx, dword ptr [ebp + 0x1c]
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   894a14               | mov                 dword ptr [edx + 0x14], ecx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8be5                 | mov                 esp, ebp

        $sequence_7 = { 50 e8???????? 8b4dec 894110 8b55fc 83c201 8955fc }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   894110               | mov                 dword ptr [ecx + 0x10], eax
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   83c201               | add                 edx, 1
            //   8955fc               | mov                 dword ptr [ebp - 4], edx

        $sequence_8 = { a1???????? 8945e0 8b0d???????? 894de4 8a15???????? 8855e8 8d45d8 }
            // n = 7, score = 100
            //   a1????????           |                     
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8b0d????????         |                     
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   8a15????????         |                     
            //   8855e8               | mov                 byte ptr [ebp - 0x18], dl
            //   8d45d8               | lea                 eax, [ebp - 0x28]

        $sequence_9 = { e9???????? 68???????? e8???????? 50 e8???????? 83c408 6a08 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   6a08                 | push                8

    condition:
        7 of them and filesize < 100352
}