rule win_infy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.infy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.infy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85ff 7e2e 4e 8bd0 }
            // n = 4, score = 200
            //   85ff                 | test                edi, edi
            //   7e2e                 | jle                 0x30
            //   4e                   | dec                 esi
            //   8bd0                 | mov                 edx, eax

        $sequence_1 = { 33d2 e8???????? eb2d 3b7df8 7514 8b45f0 }
            // n = 6, score = 200
            //   33d2                 | xor                 edx, edx
            //   e8????????           |                     
            //   eb2d                 | jmp                 0x2f
            //   3b7df8               | cmp                 edi, dword ptr [ebp - 8]
            //   7514                 | jne                 0x16
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]

        $sequence_2 = { 740e 8d45d0 50 6a03 ff15???????? 8bd8 85db }
            // n = 7, score = 200
            //   740e                 | je                  0x10
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   50                   | push                eax
            //   6a03                 | push                3
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   85db                 | test                ebx, ebx

        $sequence_3 = { 50 89c6 8b449d04 85c0 7412 }
            // n = 5, score = 200
            //   50                   | push                eax
            //   89c6                 | mov                 esi, eax
            //   8b449d04             | mov                 eax, dword ptr [ebp + ebx*4 + 4]
            //   85c0                 | test                eax, eax
            //   7412                 | je                  0x14

        $sequence_4 = { 837dec00 740b 8b45f0 8b55f8 }
            // n = 4, score = 200
            //   837dec00             | cmp                 dword ptr [ebp - 0x14], 0
            //   740b                 | je                  0xd
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]

        $sequence_5 = { 833d????????00 740e 8d55d0 52 6a01 }
            // n = 5, score = 200
            //   833d????????00       |                     
            //   740e                 | je                  0x10
            //   8d55d0               | lea                 edx, [ebp - 0x30]
            //   52                   | push                edx
            //   6a01                 | push                1

        $sequence_6 = { b8???????? e8???????? b8???????? e8???????? 807b2800 7514 }
            // n = 6, score = 200
            //   b8????????           |                     
            //   e8????????           |                     
            //   b8????????           |                     
            //   e8????????           |                     
            //   807b2800             | cmp                 byte ptr [ebx + 0x28], 0
            //   7514                 | jne                 0x16

        $sequence_7 = { 85f6 7d04 33ff eb0a 8bf8 2bfb }
            // n = 6, score = 200
            //   85f6                 | test                esi, esi
            //   7d04                 | jge                 6
            //   33ff                 | xor                 edi, edi
            //   eb0a                 | jmp                 0xc
            //   8bf8                 | mov                 edi, eax
            //   2bfb                 | sub                 edi, ebx

        $sequence_8 = { 7502 eb06 8b1b 85db }
            // n = 4, score = 200
            //   7502                 | jne                 4
            //   eb06                 | jmp                 8
            //   8b1b                 | mov                 ebx, dword ptr [ebx]
            //   85db                 | test                ebx, ebx

        $sequence_9 = { 0fb74af4 870c24 51 8b4afc e9???????? }
            // n = 5, score = 200
            //   0fb74af4             | movzx               ecx, word ptr [edx - 0xc]
            //   870c24               | xchg                dword ptr [esp], ecx
            //   51                   | push                ecx
            //   8b4afc               | mov                 ecx, dword ptr [edx - 4]
            //   e9????????           |                     

    condition:
        7 of them and filesize < 147456
}