rule win_innaput_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.innaput_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.innaput_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffb720060000 8d8f1c060000 51 ffb718060000 }
            // n = 4, score = 500
            //   ffb720060000         | push                dword ptr [edi + 0x620]
            //   8d8f1c060000         | lea                 ecx, [edi + 0x61c]
            //   51                   | push                ecx
            //   ffb718060000         | push                dword ptr [edi + 0x618]

        $sequence_1 = { 85c0 7427 ffb720060000 8d8f1c060000 51 }
            // n = 5, score = 500
            //   85c0                 | test                eax, eax
            //   7427                 | je                  0x29
            //   ffb720060000         | push                dword ptr [edi + 0x620]
            //   8d8f1c060000         | lea                 ecx, [edi + 0x61c]
            //   51                   | push                ecx

        $sequence_2 = { 8bf8 33c0 893b ab }
            // n = 4, score = 500
            //   8bf8                 | mov                 edi, eax
            //   33c0                 | xor                 eax, eax
            //   893b                 | mov                 dword ptr [ebx], edi
            //   ab                   | stosd               dword ptr es:[edi], eax

        $sequence_3 = { ff15???????? ffb718060000 ff15???????? 85c0 750c ffb71c060000 ff15???????? }
            // n = 7, score = 500
            //   ff15????????         |                     
            //   ffb718060000         | push                dword ptr [edi + 0x618]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   750c                 | jne                 0xe
            //   ffb71c060000         | push                dword ptr [edi + 0x61c]
            //   ff15????????         |                     

        $sequence_4 = { ff15???????? 85c0 750c ffb71c060000 ff15???????? 57 e8???????? }
            // n = 7, score = 500
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   750c                 | jne                 0xe
            //   ffb71c060000         | push                dword ptr [edi + 0x61c]
            //   ff15????????         |                     
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_5 = { 59 8bc6 3bf3 75ed }
            // n = 4, score = 500
            //   59                   | pop                 ecx
            //   8bc6                 | mov                 eax, esi
            //   3bf3                 | cmp                 esi, ebx
            //   75ed                 | jne                 0xffffffef

        $sequence_6 = { 751b 53 53 53 }
            // n = 4, score = 500
            //   751b                 | jne                 0x1d
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   53                   | push                ebx

        $sequence_7 = { ff15???????? 85c0 750c ffb71c060000 ff15???????? }
            // n = 5, score = 500
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   750c                 | jne                 0xe
            //   ffb71c060000         | push                dword ptr [edi + 0x61c]
            //   ff15????????         |                     

        $sequence_8 = { 85c0 7413 3bc6 740f 8b4d08 e8???????? 3b450c }
            // n = 7, score = 500
            //   85c0                 | test                eax, eax
            //   7413                 | je                  0x15
            //   3bc6                 | cmp                 eax, esi
            //   740f                 | je                  0x11
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   e8????????           |                     
            //   3b450c               | cmp                 eax, dword ptr [ebp + 0xc]

        $sequence_9 = { 2bf1 8a08 884c0616 40 84c9 75f5 }
            // n = 6, score = 500
            //   2bf1                 | sub                 esi, ecx
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   884c0616             | mov                 byte ptr [esi + eax + 0x16], cl
            //   40                   | inc                 eax
            //   84c9                 | test                cl, cl
            //   75f5                 | jne                 0xfffffff7

    condition:
        7 of them and filesize < 73728
}