rule win_invisimole_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.invisimole."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.invisimole"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c745f4ffffffff e8???????? 83c414 e9???????? 6a00 6800000008 6a03 }
            // n = 7, score = 100
            //   c745f4ffffffff       | mov                 dword ptr [ebp - 0xc], 0xffffffff
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   e9????????           |                     
            //   6a00                 | push                0
            //   6800000008           | push                0x8000000
            //   6a03                 | push                3

        $sequence_1 = { 8b0d???????? 6a04 6a08 51 ffd6 85c0 7491 }
            // n = 7, score = 100
            //   8b0d????????         |                     
            //   6a04                 | push                4
            //   6a08                 | push                8
            //   51                   | push                ecx
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   7491                 | je                  0xffffff93

        $sequence_2 = { 52 56 884d0b e8???????? 8a450c 83c448 6a01 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   56                   | push                esi
            //   884d0b               | mov                 byte ptr [ebp + 0xb], cl
            //   e8????????           |                     
            //   8a450c               | mov                 al, byte ptr [ebp + 0xc]
            //   83c448               | add                 esp, 0x48
            //   6a01                 | push                1

        $sequence_3 = { 746a 53 ff15???????? 8b4df4 51 c645ff01 ffd7 }
            // n = 7, score = 100
            //   746a                 | je                  0x6c
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   51                   | push                ecx
            //   c645ff01             | mov                 byte ptr [ebp - 1], 1
            //   ffd7                 | call                edi

        $sequence_4 = { 8d4da0 51 52 50 ff55c8 85c0 }
            // n = 6, score = 100
            //   8d4da0               | lea                 ecx, [ebp - 0x60]
            //   51                   | push                ecx
            //   52                   | push                edx
            //   50                   | push                eax
            //   ff55c8               | call                dword ptr [ebp - 0x38]
            //   85c0                 | test                eax, eax

        $sequence_5 = { c645bc0d 668955bd 894dbf 8bde 7409 83c302 66833b2a }
            // n = 7, score = 100
            //   c645bc0d             | mov                 byte ptr [ebp - 0x44], 0xd
            //   668955bd             | mov                 word ptr [ebp - 0x43], dx
            //   894dbf               | mov                 dword ptr [ebp - 0x41], ecx
            //   8bde                 | mov                 ebx, esi
            //   7409                 | je                  0xb
            //   83c302               | add                 ebx, 2
            //   66833b2a             | cmp                 word ptr [ebx], 0x2a

        $sequence_6 = { 7449 899e8caf0600 3d06010000 7305 e8???????? 899e7caf0600 0fb60f }
            // n = 7, score = 100
            //   7449                 | je                  0x4b
            //   899e8caf0600         | mov                 dword ptr [esi + 0x6af8c], ebx
            //   3d06010000           | cmp                 eax, 0x106
            //   7305                 | jae                 7
            //   e8????????           |                     
            //   899e7caf0600         | mov                 dword ptr [esi + 0x6af7c], ebx
            //   0fb60f               | movzx               ecx, byte ptr [edi]

        $sequence_7 = { 52 ffd7 8bd8 895c2414 85db }
            // n = 5, score = 100
            //   52                   | push                edx
            //   ffd7                 | call                edi
            //   8bd8                 | mov                 ebx, eax
            //   895c2414             | mov                 dword ptr [esp + 0x14], ebx
            //   85db                 | test                ebx, ebx

        $sequence_8 = { 895de8 3bde 0f8418010000 8b55ec 8b45f8 53 52 }
            // n = 7, score = 100
            //   895de8               | mov                 dword ptr [ebp - 0x18], ebx
            //   3bde                 | cmp                 ebx, esi
            //   0f8418010000         | je                  0x11e
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   53                   | push                ebx
            //   52                   | push                edx

        $sequence_9 = { 8d4602 50 8d8f22020000 51 ff15???????? 33d2 668916 }
            // n = 7, score = 100
            //   8d4602               | lea                 eax, [esi + 2]
            //   50                   | push                eax
            //   8d8f22020000         | lea                 ecx, [edi + 0x222]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   33d2                 | xor                 edx, edx
            //   668916               | mov                 word ptr [esi], dx

    condition:
        7 of them and filesize < 139264
}