rule win_jackpos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.jackpos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.jackpos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8945e4 83f805 7d10 668b4c4310 66890c45f8124200 40 ebe8 }
            // n = 7, score = 100
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   83f805               | cmp                 eax, 5
            //   7d10                 | jge                 0x12
            //   668b4c4310           | mov                 cx, word ptr [ebx + eax*2 + 0x10]
            //   66890c45f8124200     | mov                 word ptr [eax*2 + 0x4212f8], cx
            //   40                   | inc                 eax
            //   ebe8                 | jmp                 0xffffffea

        $sequence_1 = { 57 8bf8 8b450c 397518 0f86a4000000 8b4508 83c008 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8bf8                 | mov                 edi, eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   397518               | cmp                 dword ptr [ebp + 0x18], esi
            //   0f86a4000000         | jbe                 0xaa
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   83c008               | add                 eax, 8

        $sequence_2 = { 8b7508 56 c745fc04000000 e8???????? 83c404 837e7010 }
            // n = 6, score = 100
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   56                   | push                esi
            //   c745fc04000000       | mov                 dword ptr [ebp - 4], 4
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   837e7010             | cmp                 dword ptr [esi + 0x70], 0x10

        $sequence_3 = { d1ff 57 8b7d14 57 }
            // n = 4, score = 100
            //   d1ff                 | sar                 edi, 1
            //   57                   | push                edi
            //   8b7d14               | mov                 edi, dword ptr [ebp + 0x14]
            //   57                   | push                edi

        $sequence_4 = { c60700 80780100 7e04 40 8945c4 8a00 3c7f }
            // n = 7, score = 100
            //   c60700               | mov                 byte ptr [edi], 0
            //   80780100             | cmp                 byte ptr [eax + 1], 0
            //   7e04                 | jle                 6
            //   40                   | inc                 eax
            //   8945c4               | mov                 dword ptr [ebp - 0x3c], eax
            //   8a00                 | mov                 al, byte ptr [eax]
            //   3c7f                 | cmp                 al, 0x7f

        $sequence_5 = { 8b10 83c40c 51 52 8d4594 50 }
            // n = 6, score = 100
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   83c40c               | add                 esp, 0xc
            //   51                   | push                ecx
            //   52                   | push                edx
            //   8d4594               | lea                 eax, [ebp - 0x6c]
            //   50                   | push                eax

        $sequence_6 = { 03c9 51 8b4df8 8d1459 52 e8???????? 8b4614 }
            // n = 7, score = 100
            //   03c9                 | add                 ecx, ecx
            //   51                   | push                ecx
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8d1459               | lea                 edx, [ecx + ebx*2]
            //   52                   | push                edx
            //   e8????????           |                     
            //   8b4614               | mov                 eax, dword ptr [esi + 0x14]

        $sequence_7 = { 85db 0f86f8000000 57 8b7e14 }
            // n = 4, score = 100
            //   85db                 | test                ebx, ebx
            //   0f86f8000000         | jbe                 0xfe
            //   57                   | push                edi
            //   8b7e14               | mov                 edi, dword ptr [esi + 0x14]

        $sequence_8 = { ff15???????? 6aff 6a00 8bc6 8bcb e8???????? }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   6aff                 | push                -1
            //   6a00                 | push                0
            //   8bc6                 | mov                 eax, esi
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     

        $sequence_9 = { c645fc01 50 c745f001000000 e8???????? c745fc02000000 bb03000000 57 }
            // n = 7, score = 100
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   50                   | push                eax
            //   c745f001000000       | mov                 dword ptr [ebp - 0x10], 1
            //   e8????????           |                     
            //   c745fc02000000       | mov                 dword ptr [ebp - 4], 2
            //   bb03000000           | mov                 ebx, 3
            //   57                   | push                edi

    condition:
        7 of them and filesize < 319488
}