rule win_jasus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.jasus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.jasus"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 663915???????? 0f8730020000 663915???????? 0f8723020000 663915???????? 0f8716020000 663915???????? }
            // n = 7, score = 200
            //   663915????????       |                     
            //   0f8730020000         | ja                  0x236
            //   663915????????       |                     
            //   0f8723020000         | ja                  0x229
            //   663915????????       |                     
            //   0f8716020000         | ja                  0x21c
            //   663915????????       |                     

        $sequence_1 = { 740f 50 68???????? 56 e8???????? 83c40c 8b45f0 }
            // n = 7, score = 200
            //   740f                 | je                  0x11
            //   50                   | push                eax
            //   68????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]

        $sequence_2 = { e8???????? 8b54241c 8bf0 80bb8000000000 c6432d00 7412 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   8b54241c             | mov                 edx, dword ptr [esp + 0x1c]
            //   8bf0                 | mov                 esi, eax
            //   80bb8000000000       | cmp                 byte ptr [ebx + 0x80], 0
            //   c6432d00             | mov                 byte ptr [ebx + 0x2d], 0
            //   7412                 | je                  0x14

        $sequence_3 = { 8bcb 2b4e14 2bc2 3bc8 744e 8b4df8 85c9 }
            // n = 7, score = 200
            //   8bcb                 | mov                 ecx, ebx
            //   2b4e14               | sub                 ecx, dword ptr [esi + 0x14]
            //   2bc2                 | sub                 eax, edx
            //   3bc8                 | cmp                 ecx, eax
            //   744e                 | je                  0x50
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   85c9                 | test                ecx, ecx

        $sequence_4 = { 8d7b1e e8???????? 84c0 7437 a1???????? 8b55f8 }
            // n = 6, score = 200
            //   8d7b1e               | lea                 edi, [ebx + 0x1e]
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7437                 | je                  0x39
            //   a1????????           |                     
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]

        $sequence_5 = { c3 56 33f6 85db 0f889d000000 57 8bf8 }
            // n = 7, score = 200
            //   c3                   | ret                 
            //   56                   | push                esi
            //   33f6                 | xor                 esi, esi
            //   85db                 | test                ebx, ebx
            //   0f889d000000         | js                  0xa3
            //   57                   | push                edi
            //   8bf8                 | mov                 edi, eax

        $sequence_6 = { 7474 833b00 756f f644242c01 668954242e 750a }
            // n = 6, score = 200
            //   7474                 | je                  0x76
            //   833b00               | cmp                 dword ptr [ebx], 0
            //   756f                 | jne                 0x71
            //   f644242c01           | test                byte ptr [esp + 0x2c], 1
            //   668954242e           | mov                 word ptr [esp + 0x2e], dx
            //   750a                 | jne                 0xc

        $sequence_7 = { 8b8534feffff 668955c4 8b958cfeffff 6a02 }
            // n = 4, score = 200
            //   8b8534feffff         | mov                 eax, dword ptr [ebp - 0x1cc]
            //   668955c4             | mov                 word ptr [ebp - 0x3c], dx
            //   8b958cfeffff         | mov                 edx, dword ptr [ebp - 0x174]
            //   6a02                 | push                2

        $sequence_8 = { c1f905 8b0c8d809d4300 c1e006 8d440104 800820 8b4df4 b8000000c0 }
            // n = 7, score = 200
            //   c1f905               | sar                 ecx, 5
            //   8b0c8d809d4300       | mov                 ecx, dword ptr [ecx*4 + 0x439d80]
            //   c1e006               | shl                 eax, 6
            //   8d440104             | lea                 eax, [ecx + eax + 4]
            //   800820               | or                  byte ptr [eax], 0x20
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   b8000000c0           | mov                 eax, 0xc0000000

        $sequence_9 = { 68???????? e8???????? 8b8df8feffff 83c448 51 ff15???????? 83c404 }
            // n = 7, score = 200
            //   68????????           |                     
            //   e8????????           |                     
            //   8b8df8feffff         | mov                 ecx, dword ptr [ebp - 0x108]
            //   83c448               | add                 esp, 0x48
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   83c404               | add                 esp, 4

    condition:
        7 of them and filesize < 507904
}