rule win_jimmy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.jimmy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.jimmy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 e8???????? 83c40c 85c0 7460 e8???????? }
            // n = 6, score = 400
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   7460                 | je                  0x62
            //   e8????????           |                     

        $sequence_1 = { 32c0 eb6f 8b45e8 2b45f0 }
            // n = 4, score = 400
            //   32c0                 | xor                 al, al
            //   eb6f                 | jmp                 0x71
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   2b45f0               | sub                 eax, dword ptr [ebp - 0x10]

        $sequence_2 = { e8???????? 59 668945f2 ff750c e8???????? 59 }
            // n = 6, score = 400
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   668945f2             | mov                 word ptr [ebp - 0xe], ax
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_3 = { 8b4dec 0fbe09 3bc1 755b }
            // n = 4, score = 400
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   0fbe09               | movsx               ecx, byte ptr [ecx]
            //   3bc1                 | cmp                 eax, ecx
            //   755b                 | jne                 0x5d

        $sequence_4 = { c745fc12030900 e9???????? 837de805 752c ff75e4 }
            // n = 5, score = 400
            //   c745fc12030900       | mov                 dword ptr [ebp - 4], 0x90312
            //   e9????????           |                     
            //   837de805             | cmp                 dword ptr [ebp - 0x18], 5
            //   752c                 | jne                 0x2e
            //   ff75e4               | push                dword ptr [ebp - 0x1c]

        $sequence_5 = { 81ec40020000 c685cbfdffff01 6a00 6a02 e8???????? }
            // n = 5, score = 400
            //   81ec40020000         | sub                 esp, 0x240
            //   c685cbfdffff01       | mov                 byte ptr [ebp - 0x235], 1
            //   6a00                 | push                0
            //   6a02                 | push                2
            //   e8????????           |                     

        $sequence_6 = { 8d840004010000 50 e8???????? 59 89856cfeffff ff7508 }
            // n = 6, score = 400
            //   8d840004010000       | lea                 eax, [eax + eax + 0x104]
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   89856cfeffff         | mov                 dword ptr [ebp - 0x194], eax
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_7 = { eb12 8b45f8 c6805001000001 33c0 0f855effffff 8b45f8 c9 }
            // n = 7, score = 400
            //   eb12                 | jmp                 0x14
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   c6805001000001       | mov                 byte ptr [eax + 0x150], 1
            //   33c0                 | xor                 eax, eax
            //   0f855effffff         | jne                 0xffffff64
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   c9                   | leave               

        $sequence_8 = { 59 59 ff75f4 e8???????? 59 ff75f8 }
            // n = 6, score = 400
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   ff75f8               | push                dword ptr [ebp - 8]

        $sequence_9 = { 8b45f8 8945f4 8b450c 8945fc }
            // n = 4, score = 400
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

    condition:
        7 of them and filesize < 188416
}