rule win_joanap_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.joanap."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.joanap"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89510c 8b0d???????? dd442418 dd5c0810 8d9c2488030000 c744241432000000 8b43f0 }
            // n = 7, score = 100
            //   89510c               | mov                 dword ptr [ecx + 0xc], edx
            //   8b0d????????         |                     
            //   dd442418             | fld                 qword ptr [esp + 0x18]
            //   dd5c0810             | fstp                qword ptr [eax + ecx + 0x10]
            //   8d9c2488030000       | lea                 ebx, [esp + 0x388]
            //   c744241432000000     | mov                 dword ptr [esp + 0x14], 0x32
            //   8b43f0               | mov                 eax, dword ptr [ebx - 0x10]

        $sequence_1 = { 8d4c240a 6a01 51 56 ff15???????? 6a00 }
            // n = 6, score = 100
            //   8d4c240a             | lea                 ecx, [esp + 0xa]
            //   6a01                 | push                1
            //   51                   | push                ecx
            //   56                   | push                esi
            //   ff15????????         |                     
            //   6a00                 | push                0

        $sequence_2 = { 8844241a 8844241b a1???????? 89442408 8b8590010000 33d2 56 }
            // n = 7, score = 100
            //   8844241a             | mov                 byte ptr [esp + 0x1a], al
            //   8844241b             | mov                 byte ptr [esp + 0x1b], al
            //   a1????????           |                     
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   8b8590010000         | mov                 eax, dword ptr [ebp + 0x190]
            //   33d2                 | xor                 edx, edx
            //   56                   | push                esi

        $sequence_3 = { 8b3d???????? 8d4c2414 51 56 ffd7 85c0 a3???????? }
            // n = 7, score = 100
            //   8b3d????????         |                     
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   51                   | push                ecx
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   a3????????           |                     

        $sequence_4 = { 8d8c24b0000000 51 56 ffd7 85c0 a3???????? 750c }
            // n = 7, score = 100
            //   8d8c24b0000000       | lea                 ecx, [esp + 0xb0]
            //   51                   | push                ecx
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   a3????????           |                     
            //   750c                 | jne                 0xe

        $sequence_5 = { 893d???????? ff15???????? 8b842494000000 6a01 6820bf0200 53 66c74304feff }
            // n = 7, score = 100
            //   893d????????         |                     
            //   ff15????????         |                     
            //   8b842494000000       | mov                 eax, dword ptr [esp + 0x94]
            //   6a01                 | push                1
            //   6820bf0200           | push                0x2bf20
            //   53                   | push                ebx
            //   66c74304feff         | mov                 word ptr [ebx + 4], 0xfffe

        $sequence_6 = { 66c74424380040 e8???????? 83c414 83f8ff 0f8468010000 668b4610 6689442424 }
            // n = 7, score = 100
            //   66c74424380040       | mov                 word ptr [esp + 0x38], 0x4000
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   83f8ff               | cmp                 eax, -1
            //   0f8468010000         | je                  0x16e
            //   668b4610             | mov                 ax, word ptr [esi + 0x10]
            //   6689442424           | mov                 word ptr [esp + 0x24], ax

        $sequence_7 = { 83c404 eb58 8d4e03 51 e8???????? 83c404 eb4a }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   eb58                 | jmp                 0x5a
            //   8d4e03               | lea                 ecx, [esi + 3]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   eb4a                 | jmp                 0x4c

        $sequence_8 = { 8bac2424100000 8b3d???????? 8b1d???????? 894820 6a01 }
            // n = 5, score = 100
            //   8bac2424100000       | mov                 ebp, dword ptr [esp + 0x1024]
            //   8b3d????????         |                     
            //   8b1d????????         |                     
            //   894820               | mov                 dword ptr [eax + 0x20], ecx
            //   6a01                 | push                1

        $sequence_9 = { 6a01 6820bf0200 8d442418 6a04 50 56 }
            // n = 6, score = 100
            //   6a01                 | push                1
            //   6820bf0200           | push                0x2bf20
            //   8d442418             | lea                 eax, [esp + 0x18]
            //   6a04                 | push                4
            //   50                   | push                eax
            //   56                   | push                esi

    condition:
        7 of them and filesize < 270336
}