rule win_joao_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.joao."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.joao"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c404 c705????????0f000000 891d???????? 881d???????? 8b4df4 64890d00000000 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c705????????0f000000     |     
            //   891d????????         |                     
            //   881d????????         |                     
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx

        $sequence_1 = { 5d c20c00 68???????? 53 e8???????? }
            // n = 5, score = 400
            //   5d                   | pop                 ebp
            //   c20c00               | ret                 0xc
            //   68????????           |                     
            //   53                   | push                ebx
            //   e8????????           |                     

        $sequence_2 = { 83c004 8955d0 8945cc 3bd1 }
            // n = 4, score = 400
            //   83c004               | add                 eax, 4
            //   8955d0               | mov                 dword ptr [ebp - 0x30], edx
            //   8945cc               | mov                 dword ptr [ebp - 0x34], eax
            //   3bd1                 | cmp                 edx, ecx

        $sequence_3 = { e8???????? 8845d4 c745fc01000000 84c0 0f84dc000000 8b16 8d4de4 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   8845d4               | mov                 byte ptr [ebp - 0x2c], al
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1
            //   84c0                 | test                al, al
            //   0f84dc000000         | je                  0xe2
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]

        $sequence_4 = { 50 e8???????? 83c414 8b4508 c1e005 03c3 83e7e0 }
            // n = 7, score = 400
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   c1e005               | shl                 eax, 5
            //   03c3                 | add                 eax, ebx
            //   83e7e0               | and                 edi, 0xffffffe0

        $sequence_5 = { c1e005 03c3 83e7e0 03fb 894608 897e04 891e }
            // n = 7, score = 400
            //   c1e005               | shl                 eax, 5
            //   03c3                 | add                 eax, ebx
            //   83e7e0               | and                 edi, 0xffffffe0
            //   03fb                 | add                 edi, ebx
            //   894608               | mov                 dword ptr [esi + 8], eax
            //   897e04               | mov                 dword ptr [esi + 4], edi
            //   891e                 | mov                 dword ptr [esi], ebx

        $sequence_6 = { 52 6a40 6a20 68???????? ff15???????? }
            // n = 5, score = 400
            //   52                   | push                edx
            //   6a40                 | push                0x40
            //   6a20                 | push                0x20
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_7 = { 83ec08 53 56 8b7510 33c0 }
            // n = 5, score = 400
            //   83ec08               | sub                 esp, 8
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]
            //   33c0                 | xor                 eax, eax

        $sequence_8 = { 8bc6 2bc7 5f 5e 5b 5d c20c00 }
            // n = 7, score = 400
            //   8bc6                 | mov                 eax, esi
            //   2bc7                 | sub                 eax, edi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c20c00               | ret                 0xc

        $sequence_9 = { 897dfc e8???????? 8d55f8 52 8bce c745f808000000 }
            // n = 6, score = 400
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   e8????????           |                     
            //   8d55f8               | lea                 edx, [ebp - 8]
            //   52                   | push                edx
            //   8bce                 | mov                 ecx, esi
            //   c745f808000000       | mov                 dword ptr [ebp - 8], 8

    condition:
        7 of them and filesize < 2867200
}