rule win_kamasers_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kamasers."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kamasers"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c414 ebe1 8b55ec 8b4de8 8b04957885f904 807c082800 7d55 }
            // n = 7, score = 100
            //   83c414               | add                 esp, 0x14
            //   ebe1                 | jmp                 0xffffffe3
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   8b04957885f904       | mov                 eax, dword ptr [edx*4 + 0x4f98578]
            //   807c082800           | cmp                 byte ptr [eax + ecx + 0x28], 0
            //   7d55                 | jge                 0x57

        $sequence_1 = { 7602 8b06 8a4c3a04 80f13f 884c1004 83c205 83fa19 }
            // n = 7, score = 100
            //   7602                 | jbe                 4
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8a4c3a04             | mov                 cl, byte ptr [edx + edi + 4]
            //   80f13f               | xor                 cl, 0x3f
            //   884c1004             | mov                 byte ptr [eax + edx + 4], cl
            //   83c205               | add                 edx, 5
            //   83fa19               | cmp                 edx, 0x19

        $sequence_2 = { 7776 51 52 e8???????? 83c408 c745e400000000 c745e80f000000 }
            // n = 7, score = 100
            //   7776                 | ja                  0x78
            //   51                   | push                ecx
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   c745e400000000       | mov                 dword ptr [ebp - 0x1c], 0
            //   c745e80f000000       | mov                 dword ptr [ebp - 0x18], 0xf

        $sequence_3 = { 33c0 0f57c0 c78558feffff02000000 0f118548feffff 66898548feffff ba0f000000 88854afeffff }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   0f57c0               | xorps               xmm0, xmm0
            //   c78558feffff02000000     | mov    dword ptr [ebp - 0x1a8], 2
            //   0f118548feffff       | movups              xmmword ptr [ebp - 0x1b8], xmm0
            //   66898548feffff       | mov                 word ptr [ebp - 0x1b8], ax
            //   ba0f000000           | mov                 edx, 0xf
            //   88854afeffff         | mov                 byte ptr [ebp - 0x1b6], al

        $sequence_4 = { ffb5b4dbffff 8d85f0efffff f7d1 50 ffb5f8dbffff 66898dfaefffff ff95b0dbffff }
            // n = 7, score = 100
            //   ffb5b4dbffff         | push                dword ptr [ebp - 0x244c]
            //   8d85f0efffff         | lea                 eax, [ebp - 0x1010]
            //   f7d1                 | not                 ecx
            //   50                   | push                eax
            //   ffb5f8dbffff         | push                dword ptr [ebp - 0x2408]
            //   66898dfaefffff       | mov                 word ptr [ebp - 0x1006], cx
            //   ff95b0dbffff         | call                dword ptr [ebp - 0x2450]

        $sequence_5 = { 8b85e8fdffff 83f80f 7634 8b95d4fdffff 8d4801 8bc2 81f900100000 }
            // n = 7, score = 100
            //   8b85e8fdffff         | mov                 eax, dword ptr [ebp - 0x218]
            //   83f80f               | cmp                 eax, 0xf
            //   7634                 | jbe                 0x36
            //   8b95d4fdffff         | mov                 edx, dword ptr [ebp - 0x22c]
            //   8d4801               | lea                 ecx, [eax + 1]
            //   8bc2                 | mov                 eax, edx
            //   81f900100000         | cmp                 ecx, 0x1000

        $sequence_6 = { 0f85be000000 8d4dd4 e8???????? 50 8d4d98 e8???????? 8b4de8 }
            // n = 7, score = 100
            //   0f85be000000         | jne                 0xc4
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   e8????????           |                     
            //   50                   | push                eax
            //   8d4d98               | lea                 ecx, [ebp - 0x68]
            //   e8????????           |                     
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]

        $sequence_7 = { 6a01 68???????? 8d8d40edffff c645fc13 e8???????? c785fcd8ffff00000000 }
            // n = 6, score = 100
            //   6a01                 | push                1
            //   68????????           |                     
            //   8d8d40edffff         | lea                 ecx, [ebp - 0x12c0]
            //   c645fc13             | mov                 byte ptr [ebp - 4], 0x13
            //   e8????????           |                     
            //   c785fcd8ffff00000000     | mov    dword ptr [ebp - 0x2704], 0

        $sequence_8 = { 0f875c070000 51 52 e8???????? 83c408 837de80f }
            // n = 6, score = 100
            //   0f875c070000         | ja                  0x762
            //   51                   | push                ecx
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   837de80f             | cmp                 dword ptr [ebp - 0x18], 0xf

        $sequence_9 = { 8bc8 2bcf b8abaaaa2a f7e9 8b4b04 c1fa02 2bcf }
            // n = 7, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   2bcf                 | sub                 ecx, edi
            //   b8abaaaa2a           | mov                 eax, 0x2aaaaaab
            //   f7e9                 | imul                ecx
            //   8b4b04               | mov                 ecx, dword ptr [ebx + 4]
            //   c1fa02               | sar                 edx, 2
            //   2bcf                 | sub                 ecx, edi

    condition:
        7 of them and filesize < 906240
}