rule win_kapeka_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kapeka."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kapeka"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 498bcf e8???????? 488d15a8530100 488bc8 e8???????? ba02100000 488d4d10 }
            // n = 7, score = 100
            //   498bcf               | dec                 eax
            //   e8????????           |                     
            //   488d15a8530100       | lea                 ecx, [esp + 0x30]
            //   488bc8               | dec                 eax
            //   e8????????           |                     
            //   ba02100000           | mov                 ecx, edi
            //   488d4d10             | dec                 eax

        $sequence_1 = { 488bda 488bf9 e8???????? 488bd3 48895f28 488bcf e8???????? }
            // n = 7, score = 100
            //   488bda               | dec                 esp
            //   488bf9               | lea                 ecx, [eax + eax]
            //   e8????????           |                     
            //   488bd3               | dec                 esp
            //   48895f28             | lea                 eax, [esi + esi]
            //   488bcf               | dec                 eax
            //   e8????????           |                     

        $sequence_2 = { 488bc8 e8???????? 488be8 eb03 488bef 488d4c2420 e8???????? }
            // n = 7, score = 100
            //   488bc8               | mov                 dword ptr [eax + 8], ecx
            //   e8????????           |                     
            //   488be8               | dec                 ecx
            //   eb03                 | mov                 dword ptr [eax + 0x10], 0
            //   488bef               | dec                 eax
            //   488d4c2420           | mov                 eax, dword ptr [edi + 0x40]
            //   e8????????           |                     

        $sequence_3 = { 4803c8 e8???????? 488b442468 488b4c2460 482bc1 }
            // n = 5, score = 100
            //   4803c8               | inc                 ecx
            //   e8????????           |                     
            //   488b442468           | xor                 ebx, dword ptr [esi + eax*4 + 0x1e170]
            //   488b4c2460           | inc                 ecx
            //   482bc1               | xor                 ebx, dword ptr [edi + 0xc]

        $sequence_4 = { 418bc3 c1e810 0fb6c8 418bbc9470dd0100 4133bc8c70d90100 8bc6 48c1e818 }
            // n = 7, score = 100
            //   418bc3               | dec                 eax
            //   c1e810               | lea                 ecx, [ebx + 0xa8]
            //   0fb6c8               | dec                 eax
            //   418bbc9470dd0100     | mov                 dword ptr [edi + 0x38], ebp
            //   4133bc8c70d90100     | dec                 eax
            //   8bc6                 | mov                 dword ptr [edi + 0x40], ebp
            //   48c1e818             | dec                 esp

        $sequence_5 = { 8d4f01 e8???????? 488b4b10 488903 48894308 488b5328 }
            // n = 6, score = 100
            //   8d4f01               | dec                 ecx
            //   e8????????           |                     
            //   488b4b10             | inc                 ecx
            //   488903               | dec                 ecx
            //   48894308             | mov                 eax, ecx
            //   488b5328             | dec                 eax

        $sequence_6 = { 57 4154 4157 4883ec70 488bf9 4c8d252b470100 4c8921 }
            // n = 7, score = 100
            //   57                   | sub                 ecx, ecx
            //   4154                 | inc                 ecx
            //   4157                 | cmp                 eax, 0x7ffffffd
            //   4883ec70             | inc                 esp
            //   488bf9               | cmovbe              ecx, ecx
            //   4c8d252b470100       | inc                 ebp
            //   4c8921               | mov                 eax, ecx

        $sequence_7 = { e8???????? 488bcb e8???????? 488b5c2430 48894728 4883c420 5f }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488bcb               | dec                 eax
            //   e8????????           |                     
            //   488b5c2430           | lea                 ecx, [esp + 0x20]
            //   48894728             | inc                 ecx
            //   4883c420             | mov                 eax, 0x20a
            //   5f                   | dec                 eax

        $sequence_8 = { 418bc2 c1e810 0fb6c8 418bc3 418bb49670dd0100 48c1e818 4133b48e70d90100 }
            // n = 7, score = 100
            //   418bc2               | mov                 dword ptr [ecx + 8], eax
            //   c1e810               | dec                 eax
            //   0fb6c8               | mov                 dword ptr [ecx + 0x10], edx
            //   418bc3               | dec                 eax
            //   418bb49670dd0100     | mov                 dword ptr [ecx + 0x18], esi
            //   48c1e818             | dec                 esp
            //   4133b48e70d90100     | mov                 dword ptr [ecx + 0x20], ecx

        $sequence_9 = { 488b442468 4c894138 4533c0 48895158 33d2 48894150 4c894940 }
            // n = 7, score = 100
            //   488b442468           | mov                 esi, dword ptr [ecx + 0x10]
            //   4c894138             | dec                 ecx
            //   4533c0               | lea                 edx, [esi + ebx]
            //   48895158             | test                al, al
            //   33d2                 | je                  0x45c
            //   48894150             | dec                 eax
            //   4c894940             | test                ebx, ebx

    condition:
        7 of them and filesize < 377856
}