rule win_kardonloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kardonloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kardonloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c0e904 8a8018314000 c0e002 0ac8 880c32 8bc2 }
            // n = 6, score = 200
            //   c0e904               | shr                 cl, 4
            //   8a8018314000         | mov                 al, byte ptr [eax + 0x403118]
            //   c0e002               | shl                 al, 2
            //   0ac8                 | or                  cl, al
            //   880c32               | mov                 byte ptr [edx + esi], cl
            //   8bc2                 | mov                 eax, edx

        $sequence_1 = { 663bc8 751c 8b4208 8bf0 c1ee10 6683f801 6a06 }
            // n = 7, score = 200
            //   663bc8               | cmp                 cx, ax
            //   751c                 | jne                 0x1e
            //   8b4208               | mov                 eax, dword ptr [edx + 8]
            //   8bf0                 | mov                 esi, eax
            //   c1ee10               | shr                 esi, 0x10
            //   6683f801             | cmp                 ax, 1
            //   6a06                 | push                6

        $sequence_2 = { 89450c 786a 0fb6443b01 8a9018314000 0fb6443b02 8a9818314000 }
            // n = 6, score = 200
            //   89450c               | mov                 dword ptr [ebp + 0xc], eax
            //   786a                 | js                  0x6c
            //   0fb6443b01           | movzx               eax, byte ptr [ebx + edi + 1]
            //   8a9018314000         | mov                 dl, byte ptr [eax + 0x403118]
            //   0fb6443b02           | movzx               eax, byte ptr [ebx + edi + 2]
            //   8a9818314000         | mov                 bl, byte ptr [eax + 0x403118]

        $sequence_3 = { 68???????? e8???????? 8bf0 85f6 0f844a010000 }
            // n = 5, score = 200
            //   68????????           |                     
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   0f844a010000         | je                  0x150

        $sequence_4 = { 7819 53 6800040000 8d8550f6ffff }
            // n = 4, score = 200
            //   7819                 | js                  0x1b
            //   53                   | push                ebx
            //   6800040000           | push                0x400
            //   8d8550f6ffff         | lea                 eax, [ebp - 0x9b0]

        $sequence_5 = { 58 0fb7f1 663bc8 751c 8b4208 8bf0 }
            // n = 6, score = 200
            //   58                   | pop                 eax
            //   0fb7f1               | movzx               esi, cx
            //   663bc8               | cmp                 cx, ax
            //   751c                 | jne                 0x1e
            //   8b4208               | mov                 eax, dword ptr [edx + 8]
            //   8bf0                 | mov                 esi, eax

        $sequence_6 = { 84c0 ba???????? b9???????? 8d857cffffff 0f44ca }
            // n = 5, score = 200
            //   84c0                 | test                al, al
            //   ba????????           |                     
            //   b9????????           |                     
            //   8d857cffffff         | lea                 eax, [ebp - 0x84]
            //   0f44ca               | cmove               ecx, edx

        $sequence_7 = { 51 8d8578fcffff 50 68???????? }
            // n = 4, score = 200
            //   51                   | push                ecx
            //   8d8578fcffff         | lea                 eax, [ebp - 0x388]
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_8 = { 8bec 81ec1c020000 56 8b35???????? 57 6810270000 ffd6 }
            // n = 7, score = 200
            //   8bec                 | mov                 ebp, esp
            //   81ec1c020000         | sub                 esp, 0x21c
            //   56                   | push                esi
            //   8b35????????         |                     
            //   57                   | push                edi
            //   6810270000           | push                0x2710
            //   ffd6                 | call                esi

        $sequence_9 = { 83c40c 8bcf 5f c6043100 8bc6 5e }
            // n = 6, score = 200
            //   83c40c               | add                 esp, 0xc
            //   8bcf                 | mov                 ecx, edi
            //   5f                   | pop                 edi
            //   c6043100             | mov                 byte ptr [ecx + esi], 0
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi

    condition:
        7 of them and filesize < 57344
}