rule win_karius_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.karius."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.karius"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 41b830000000 488bcf ff15???????? 4885c0 }
            // n = 4, score = 400
            //   41b830000000         | add                 ebx, esi
            //   488bcf               | inc                 ecx
            //   ff15????????         |                     
            //   4885c0               | mov                 ebx, dword ptr [ebx + 0x18]

        $sequence_1 = { 85db 0f8477000000 8bb424b0000000 418b10 }
            // n = 4, score = 400
            //   85db                 | je                  0x9d
            //   0f8477000000         | inc                 ebp
            //   8bb424b0000000       | mov                 eax, dword ptr [ebx + 0x20]
            //   418b10               | inc                 ebp

        $sequence_2 = { 8bb424b0000000 418b10 8bcd 4903d6 0fb602 }
            // n = 5, score = 400
            //   8bb424b0000000       | inc                 ebp
            //   418b10               | mov                 eax, dword ptr [ebx + 0x20]
            //   8bcd                 | je                  0xb9
            //   4903d6               | inc                 ebp
            //   0fb602               | mov                 ebx, dword ptr [edi + 0x88]

        $sequence_3 = { 4d03d6 448bcd 85db 0f8477000000 }
            // n = 4, score = 400
            //   4d03d6               | mov                 ecx, ebp
            //   448bcd               | test                ebx, ebx
            //   85db                 | je                  0x7f
            //   0f8477000000         | mov                 esi, dword ptr [esp + 0xb0]

        $sequence_4 = { 488b05???????? 4885c0 7512 ff15???????? 488905???????? 4885c0 }
            // n = 6, score = 400
            //   488b05????????       |                     
            //   4885c0               | inc                 ecx
            //   7512                 | mov                 ebx, dword ptr [ebx + 0x18]
            //   ff15????????         |                     
            //   488905????????       |                     
            //   4885c0               | test                ebx, ebx

        $sequence_5 = { 0f849d000000 41837b1400 0f8492000000 458b4320 458b5324 33ed }
            // n = 6, score = 400
            //   0f849d000000         | mov                 ebx, dword ptr [ebx + 0x18]
            //   41837b1400           | test                ebx, ebx
            //   0f8492000000         | je                  0xa3
            //   458b4320             | je                  0xa3
            //   458b5324             | inc                 ecx
            //   33ed                 | cmp                 dword ptr [ebx + 0x14], 0

        $sequence_6 = { bf01000000 8bd7 498bce ffd3 4183bf8c00000000 }
            // n = 5, score = 400
            //   bf01000000           | dec                 ebp
            //   8bd7                 | add                 eax, esi
            //   498bce               | dec                 ebp
            //   ffd3                 | add                 edx, esi
            //   4183bf8c00000000     | inc                 esp

        $sequence_7 = { c3 85c0 7505 e8???????? b801000000 }
            // n = 5, score = 400
            //   c3                   | test                ebx, ebx
            //   85c0                 | je                  0x85
            //   7505                 | mov                 esi, dword ptr [esp + 0xb0]
            //   e8????????           |                     
            //   b801000000           | inc                 ecx

        $sequence_8 = { 0f84b3000000 458b9f88000000 4d03de 418b5b18 85db 0f849d000000 }
            // n = 6, score = 400
            //   0f84b3000000         | je                  0xb9
            //   458b9f88000000       | inc                 ebp
            //   4d03de               | mov                 ebx, dword ptr [edi + 0x88]
            //   418b5b18             | dec                 ebp
            //   85db                 | add                 ebx, esi
            //   0f849d000000         | inc                 ecx

        $sequence_9 = { 41 ff45fc 42 ff45f8 }
            // n = 4, score = 300
            //   41                   | dec                 ecx
            //   ff45fc               | mov                 ecx, esi
            //   42                   | call                ebx
            //   ff45f8               | inc                 ecx

        $sequence_10 = { 8bc7 ffc8 7416 ffc8 }
            // n = 4, score = 300
            //   8bc7                 | inc                 ecx
            //   ffc8                 | mov                 edx, dword ptr [eax]
            //   7416                 | mov                 ecx, ebp
            //   ffc8                 | dec                 ecx

        $sequence_11 = { 81c200000100 8955f8 b804000000 8945fc 81fa80000000 7307 }
            // n = 6, score = 300
            //   81c200000100         | inc                 ebp
            //   8955f8               | mov                 edx, dword ptr [ebx + 0x24]
            //   b804000000           | xor                 ebp, ebp
            //   8945fc               | dec                 ebp
            //   81fa80000000         | add                 eax, esi
            //   7307                 | dec                 ebp

        $sequence_12 = { 4d8bc7 488bd0 488bce ff15???????? }
            // n = 4, score = 300
            //   4d8bc7               | add                 edx, esi
            //   488bd0               | inc                 esp
            //   488bce               | mov                 ecx, ebp
            //   ff15????????         |                     

        $sequence_13 = { 7405 f60001 7502 33c0 }
            // n = 4, score = 300
            //   7405                 | mov                 edx, dword ptr [eax]
            //   f60001               | mov                 ecx, ebp
            //   7502                 | dec                 ecx
            //   33c0                 | add                 edx, esi

        $sequence_14 = { 48895c2420 4d8bcc 4d8bc7 488bd0 }
            // n = 4, score = 300
            //   48895c2420           | je                  0xa3
            //   4d8bcc               | inc                 ecx
            //   4d8bc7               | cmp                 dword ptr [ebx + 0x14], 0
            //   488bd0               | je                  0x9d

        $sequence_15 = { 33d2 488bce ff15???????? 4c8bf0 4885c0 }
            // n = 5, score = 300
            //   33d2                 | mov                 ecx, ebp
            //   488bce               | dec                 eax
            //   ff15????????         |                     
            //   4c8bf0               | test                eax, eax
            //   4885c0               | jne                 0x14

        $sequence_16 = { 47 41 3bfb 0f825ffeffff }
            // n = 4, score = 300
            //   47                   | cmp                 dword ptr [edi + 0x8c], 0
            //   41                   | je                  0x98
            //   3bfb                 | inc                 ebp
            //   0f825ffeffff         | mov                 eax, dword ptr [ebx + 0x20]

        $sequence_17 = { 7505 8d7b02 eb09 6685c0 }
            // n = 4, score = 300
            //   7505                 | add                 ebx, esi
            //   8d7b02               | inc                 ecx
            //   eb09                 | mov                 ebx, dword ptr [ebx + 0x18]
            //   6685c0               | test                ebx, ebx

        $sequence_18 = { 8a17 80fa41 7c0d 80fa5a }
            // n = 4, score = 300
            //   8a17                 | cmp                 dword ptr [ebx + 0x14], 0
            //   80fa41               | je                  0x9d
            //   7c0d                 | inc                 ebp
            //   80fa5a               | mov                 eax, dword ptr [ebx + 0x20]

        $sequence_19 = { ff15???????? 4c8be8 498bce ff15???????? 4d85ed }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   4c8be8               | call                ebx
            //   498bce               | inc                 ecx
            //   ff15????????         |                     
            //   4d85ed               | cmp                 dword ptr [edi + 0x8c], 0

        $sequence_20 = { ebb0 8b5d10 8b750c 8b4d08 47 8b55f4 41 }
            // n = 7, score = 300
            //   ebb0                 | add                 eax, esi
            //   8b5d10               | dec                 ebp
            //   8b750c               | add                 edx, esi
            //   8b4d08               | inc                 esp
            //   47                   | mov                 ecx, ebp
            //   8b55f4               | test                ebx, ebx
            //   41                   | je                  0x85

        $sequence_21 = { 7e26 3c5b 750a 5e 894d0c }
            // n = 5, score = 300
            //   7e26                 | mov                 esi, dword ptr [esp + 0xb0]
            //   3c5b                 | dec                 ecx
            //   750a                 | mov                 ecx, esi
            //   5e                   | call                ebx
            //   894d0c               | inc                 ecx

        $sequence_22 = { 488d4b10 488d542450 41b804000000 c6430f68 }
            // n = 4, score = 300
            //   488d4b10             | je                  0x7d
            //   488d542450           | mov                 esi, dword ptr [esp + 0xb0]
            //   41b804000000         | inc                 ecx
            //   c6430f68             | mov                 edx, dword ptr [eax]

        $sequence_23 = { 41 7411 43 3c5c }
            // n = 4, score = 300
            //   41                   | inc                 ebp
            //   7411                 | mov                 edx, dword ptr [ebx + 0x24]
            //   43                   | mov                 edi, 1
            //   3c5c                 | mov                 edx, edi

        $sequence_24 = { 4d8bcf 33d2 41b800001000 488bce }
            // n = 4, score = 300
            //   4d8bcf               | inc                 ecx
            //   33d2                 | cmp                 dword ptr [edi + 0x8c], 0
            //   41b800001000         | je                  0xc6
            //   488bce               | dec                 ecx

        $sequence_25 = { 7c04 3c39 7ee3 803f2e }
            // n = 4, score = 300
            //   7c04                 | movzx               eax, byte ptr [edx]
            //   3c39                 | nop                 dword ptr [eax + eax]
            //   7ee3                 | je                  0xa3
            //   803f2e               | inc                 ecx

    condition:
        7 of them and filesize < 434176
}