rule win_karma_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.karma."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.karma"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a08 6a00 8944243c ffd6 50 ffd3 6a40 }
            // n = 7, score = 100
            //   6a08                 | push                8
            //   6a00                 | push                0
            //   8944243c             | mov                 dword ptr [esp + 0x3c], eax
            //   ffd6                 | call                esi
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   6a40                 | push                0x40

        $sequence_1 = { 8b450c 751c 41 83f908 72f1 }
            // n = 5, score = 100
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   751c                 | jne                 0x1e
            //   41                   | inc                 ecx
            //   83f908               | cmp                 ecx, 8
            //   72f1                 | jb                  0xfffffff3

        $sequence_2 = { 8b0d???????? 33c0 3801 740a }
            // n = 4, score = 100
            //   8b0d????????         |                     
            //   33c0                 | xor                 eax, eax
            //   3801                 | cmp                 byte ptr [ecx], al
            //   740a                 | je                  0xc

        $sequence_3 = { 8bf1 33d2 57 663916 7409 }
            // n = 5, score = 100
            //   8bf1                 | mov                 esi, ecx
            //   33d2                 | xor                 edx, edx
            //   57                   | push                edi
            //   663916               | cmp                 word ptr [esi], dx
            //   7409                 | je                  0xb

        $sequence_4 = { 668901 8d5202 6685c0 75ef 8bcf ba???????? }
            // n = 6, score = 100
            //   668901               | mov                 word ptr [ecx], ax
            //   8d5202               | lea                 edx, [edx + 2]
            //   6685c0               | test                ax, ax
            //   75ef                 | jne                 0xfffffff1
            //   8bcf                 | mov                 ecx, edi
            //   ba????????           |                     

        $sequence_5 = { 750e 6685db 0f8478040000 83c702 ebc8 33ff }
            // n = 6, score = 100
            //   750e                 | jne                 0x10
            //   6685db               | test                bx, bx
            //   0f8478040000         | je                  0x47e
            //   83c702               | add                 edi, 2
            //   ebc8                 | jmp                 0xffffffca
            //   33ff                 | xor                 edi, edi

        $sequence_6 = { c1c80e 33c7 8b7b14 8903 8d0437 c1c007 314324 }
            // n = 7, score = 100
            //   c1c80e               | ror                 eax, 0xe
            //   33c7                 | xor                 eax, edi
            //   8b7b14               | mov                 edi, dword ptr [ebx + 0x14]
            //   8903                 | mov                 dword ptr [ebx], eax
            //   8d0437               | lea                 eax, [edi + esi]
            //   c1c007               | rol                 eax, 7
            //   314324               | xor                 dword ptr [ebx + 0x24], eax

        $sequence_7 = { 8bf1 eb02 33f6 0fb74102 }
            // n = 4, score = 100
            //   8bf1                 | mov                 esi, ecx
            //   eb02                 | jmp                 4
            //   33f6                 | xor                 esi, esi
            //   0fb74102             | movzx               eax, word ptr [ecx + 2]

        $sequence_8 = { 6685c0 7429 0fb7d0 6683fa5c 7410 }
            // n = 5, score = 100
            //   6685c0               | test                ax, ax
            //   7429                 | je                  0x2b
            //   0fb7d0               | movzx               edx, ax
            //   6683fa5c             | cmp                 dx, 0x5c
            //   7410                 | je                  0x12

        $sequence_9 = { 66833c45f051400000 75f4 33d2 663915???????? 7415 660f1f840000000000 }
            // n = 6, score = 100
            //   66833c45f051400000     | cmp    word ptr [eax*2 + 0x4051f0], 0
            //   75f4                 | jne                 0xfffffff6
            //   33d2                 | xor                 edx, edx
            //   663915????????       |                     
            //   7415                 | je                  0x17
            //   660f1f840000000000     | nop    word ptr [eax + eax]

    condition:
        7 of them and filesize < 49208
}