rule win_kasperagent_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kasperagent."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kasperagent"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd0 c645fc03 8b45bc 83c0f0 8d480c 83caff }
            // n = 6, score = 200
            //   ffd0                 | call                eax
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   8b45bc               | mov                 eax, dword ptr [ebp - 0x44]
            //   83c0f0               | add                 eax, -0x10
            //   8d480c               | lea                 ecx, [eax + 0xc]
            //   83caff               | or                  edx, 0xffffffff

        $sequence_1 = { 83c002 47 3bce 75eb 8bc3 3b5c2410 }
            // n = 6, score = 200
            //   83c002               | add                 eax, 2
            //   47                   | inc                 edi
            //   3bce                 | cmp                 ecx, esi
            //   75eb                 | jne                 0xffffffed
            //   8bc3                 | mov                 eax, ebx
            //   3b5c2410             | cmp                 ebx, dword ptr [esp + 0x10]

        $sequence_2 = { 84db 7524 8b4500 83e810 ba01000000 }
            // n = 5, score = 200
            //   84db                 | test                bl, bl
            //   7524                 | jne                 0x26
            //   8b4500               | mov                 eax, dword ptr [ebp]
            //   83e810               | sub                 eax, 0x10
            //   ba01000000           | mov                 edx, 1

        $sequence_3 = { 663b54243a 7516 668b460c 663b44243c 750b b801000000 5f }
            // n = 7, score = 200
            //   663b54243a           | cmp                 dx, word ptr [esp + 0x3a]
            //   7516                 | jne                 0x18
            //   668b460c             | mov                 ax, word ptr [esi + 0xc]
            //   663b44243c           | cmp                 ax, word ptr [esp + 0x3c]
            //   750b                 | jne                 0xd
            //   b801000000           | mov                 eax, 1
            //   5f                   | pop                 edi

        $sequence_4 = { 0fb74c2418 81c26c070000 40 668916 }
            // n = 4, score = 200
            //   0fb74c2418           | movzx               ecx, word ptr [esp + 0x18]
            //   81c26c070000         | add                 edx, 0x76c
            //   40                   | inc                 eax
            //   668916               | mov                 word ptr [esi], dx

        $sequence_5 = { 2bc6 0bd0 b301 7d08 56 8bcd e8???????? }
            // n = 7, score = 200
            //   2bc6                 | sub                 eax, esi
            //   0bd0                 | or                  edx, eax
            //   b301                 | mov                 bl, 1
            //   7d08                 | jge                 0xa
            //   56                   | push                esi
            //   8bcd                 | mov                 ecx, ebp
            //   e8????????           |                     

        $sequence_6 = { 56 57 33ff 66837c24182d 897c2414 7472 }
            // n = 6, score = 200
            //   56                   | push                esi
            //   57                   | push                edi
            //   33ff                 | xor                 edi, edi
            //   66837c24182d         | cmp                 word ptr [esp + 0x18], 0x2d
            //   897c2414             | mov                 dword ptr [esp + 0x14], edi
            //   7472                 | je                  0x74

        $sequence_7 = { 89442408 8d742410 8d442408 c7470800000000 }
            // n = 4, score = 200
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   8d742410             | lea                 esi, [esp + 0x10]
            //   8d442408             | lea                 eax, [esp + 8]
            //   c7470800000000       | mov                 dword ptr [edi + 8], 0

        $sequence_8 = { ff500c 837d0800 75cc 5b 5d c20400 8bff }
            // n = 7, score = 200
            //   ff500c               | call                dword ptr [eax + 0xc]
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   75cc                 | jne                 0xffffffce
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   8bff                 | mov                 edi, edi

        $sequence_9 = { 57 56 ff15???????? 33c9 894c2430 894c2434 894c2438 }
            // n = 7, score = 200
            //   57                   | push                edi
            //   56                   | push                esi
            //   ff15????????         |                     
            //   33c9                 | xor                 ecx, ecx
            //   894c2430             | mov                 dword ptr [esp + 0x30], ecx
            //   894c2434             | mov                 dword ptr [esp + 0x34], ecx
            //   894c2438             | mov                 dword ptr [esp + 0x38], ecx

    condition:
        7 of them and filesize < 1605632
}