rule win_katz_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.katz_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.katz_stealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd5 85c0 7516 6aff 5a 488b8c2480000000 ff15???????? }
            // n = 7, score = 100
            //   ffd5                 | lea                 eax, [0x657d]
            //   85c0                 | mov                 edx, 0x104
            //   7516                 | dec                 eax
            //   6aff                 | lea                 ecx, [esp + 0xfa0]
            //   5a                   | dec                 esp
            //   488b8c2480000000     | lea                 ecx, [esp + 0xe9c]
            //   ff15????????         |                     

        $sequence_1 = { 31c9 e8???????? 4893 e9???????? 85f6 }
            // n = 5, score = 100
            //   31c9                 | lea                 ecx, [0x8d18]
            //   e8????????           |                     
            //   4893                 | push                ebx
            //   e9????????           |                     
            //   85f6                 | push                esi

        $sequence_2 = { 0f8517ffffff e9???????? 4889f9 ff15???????? 83f8ff 0f84ba030000 85db }
            // n = 7, score = 100
            //   0f8517ffffff         | dec                 eax
            //   e9????????           |                     
            //   4889f9               | lea                 edx, [0xcca7]
            //   ff15????????         |                     
            //   83f8ff               | dec                 eax
            //   0f84ba030000         | mov                 ecx, dword ptr [esp + 0x48]
            //   85db                 | xor                 eax, eax

        $sequence_3 = { 488b4c2470 e8???????? 488b5c2450 8b742460 39b42480000000 }
            // n = 5, score = 100
            //   488b4c2470           | mov                 eax, ebx
            //   e8????????           |                     
            //   488b5c2450           | dec                 eax
            //   8b742460             | lea                 edx, [esp + 0x12ac]
            //   39b42480000000       | dec                 eax

        $sequence_4 = { e9???????? 4885d2 0f8429ffffff 488d0562f30000 4889842490000000 4c8b842490000000 }
            // n = 6, score = 100
            //   e9????????           |                     
            //   4885d2               | dec                 eax
            //   0f8429ffffff         | mov                 ecx, dword ptr [eax + edi*8]
            //   488d0562f30000       | dec                 eax
            //   4889842490000000     | inc                 edi
            //   4c8b842490000000     | cmp                 dword ptr [ebx + 8], edi

        $sequence_5 = { e8???????? 66490f6ec5 66480f6ee7 4889f1 f20f5ec4 488d15dab00000 f20f5905???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   66490f6ec5           | mov                 edx, 0x104
            //   66480f6ee7           | dec                 eax
            //   4889f1               | lea                 ecx, [esp + 0x288]
            //   f20f5ec4             | dec                 esp
            //   488d15dab00000       | lea                 eax, [0x649b]
            //   f20f5905????????     |                     

        $sequence_6 = { 488b8424b0070000 488d15663a0000 4889d9 488b04f8 448b4004 e8???????? }
            // n = 6, score = 100
            //   488b8424b0070000     | mov                 edx, 0x104
            //   488d15663a0000       | dec                 esp
            //   4889d9               | mov                 ecx, edx
            //   488b04f8             | dec                 esp
            //   448b4004             | lea                 eax, [0x2b5a]
            //   e8????????           |                     

        $sequence_7 = { f3ab 488d15f64c0000 4889f1 488dbc2494050000 e8???????? 4885c0 7449 }
            // n = 7, score = 100
            //   f3ab                 | lea                 ecx, [esp + 0x350]
            //   488d15f64c0000       | dec                 eax
            //   4889f1               | lea                 ecx, [esp + 0x148]
            //   488dbc2494050000     | dec                 eax
            //   e8????????           |                     
            //   4885c0               | test                eax, eax
            //   7449                 | je                  0x612

        $sequence_8 = { 4c89c7 f3ab 488d0d075d0000 48b80100000006000000 4889842490020000 4c8d8c2480010000 }
            // n = 6, score = 100
            //   4c89c7               | push                3
            //   f3ab                 | inc                 ebp
            //   488d0d075d0000       | xor                 ecx, ecx
            //   48b80100000006000000     | dec    eax
            //   4889842490020000     | mov                 ecx, esi
            //   4c8d8c2480010000     | cmp                 eax, 4

        $sequence_9 = { 4489c8 4883c468 5b 5e c3 f6c701 0f8477010000 }
            // n = 7, score = 100
            //   4489c8               | mov                 dword ptr [esp + 0x50], eax
            //   4883c468             | call                dword ptr [esp + 0x68]
            //   5b                   | inc                 ebp
            //   5e                   | mov                 eax, ebp
            //   c3                   | inc                 esp
            //   f6c701               | mov                 edx, esp
            //   0f8477010000         | dec                 eax

    condition:
        7 of them and filesize < 238592
}