rule win_kazuar_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kazuar."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kazuar"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7452 83b98c00000000 7449 4c01de 31db 8b6e20 448b6618 }
            // n = 7, score = 300
            //   7452                 | sub                 esp, 0x10
            //   83b98c00000000       | test                eax, eax
            //   7449                 | jns                 0x135e
            //   4c01de               | mov                 dword ptr [ebx], eax
            //   31db                 | mov                 dword ptr [ebx + 4], 0x195
            //   8b6e20               | call                ecx
            //   448b6618             | sub                 esp, 0x10

        $sequence_1 = { 83c002 c744240400000000 668945f2 8d45ec c7042400000000 8944240c 8d45f0 }
            // n = 7, score = 300
            //   83c002               | dec                 eax
            //   c744240400000000     | mov                 ecx, ebx
            //   668945f2             | dec                 eax
            //   8d45ec               | test                eax, eax
            //   c7042400000000       | je                  0xfffffffa
            //   8944240c             | dec                 eax
            //   8d45f0               | lea                 edx, [0xf55]

        $sequence_2 = { e8???????? 89c3 e8???????? 01c0 895df4 }
            // n = 5, score = 300
            //   e8????????           |                     
            //   89c3                 | lea                 ecx, [ebx + 8]
            //   e8????????           |                     
            //   01c0                 | mov                 dword ptr [esp + 4], ecx
            //   895df4               | mov                 dword ptr [esp + 0x10], ecx

        $sequence_3 = { 31c0 4885c9 4989cb 89d7 7463 4863493c }
            // n = 6, score = 300
            //   31c0                 | jmp                 0x5d
            //   4885c9               | mov                 eax, dword ptr [esi + 0x24]
            //   4989cb               | dec                 eax
            //   89d7                 | add                 ebx, ebx
            //   7463                 | dec                 esp
            //   4863493c             | add                 ebx, ebx

        $sequence_4 = { 8b0402 4c01d8 eb07 48ffc3 ebc8 31c0 }
            // n = 6, score = 300
            //   8b0402               | inc                 ecx
            //   4c01d8               | mov                 eax, 0x104
            //   eb07                 | dec                 eax
            //   48ffc3               | lea                 ebx, [esp + 0x2c]
            //   ebc8                 | dec                 eax
            //   31c0                 | mov                 edx, ebx

        $sequence_5 = { 8d8b00030000 894c2408 8d4b08 894c2404 ff522c 83ec18 }
            // n = 6, score = 300
            //   8d8b00030000         | dec                 eax
            //   894c2408             | mov                 ecx, ebx
            //   8d4b08               | mov                 dl, 1
            //   894c2404             | mov                 al, dl
            //   ff522c               | dec                 eax
            //   83ec18               | add                 esp, 0x130

        $sequence_6 = { 6685c9 7417 e8???????? 0fb7c0 41ffc1 }
            // n = 5, score = 300
            //   6685c9               | dec                 eax
            //   7417                 | add                 esp, 0x48
            //   e8????????           |                     
            //   0fb7c0               | ret                 
            //   41ffc1               | dec                 eax

        $sequence_7 = { 31c0 4885db 7428 4989db 498b4b40 e8???????? 3d88ae6393 }
            // n = 7, score = 300
            //   31c0                 | sub                 esp, 0xc
            //   4885db               | test                eax, eax
            //   7428                 | jns                 0xdb4
            //   4989db               | mov                 dword ptr [ebx], eax
            //   498b4b40             | mov                 dword ptr [esp + 8], edx
            //   e8????????           |                     
            //   3d88ae6393           | call                ecx

        $sequence_8 = { 7425 e8???????? 39f8 751c 8b4624 4801db }
            // n = 6, score = 300
            //   7425                 | xor                 esi, esi
            //   e8????????           |                     
            //   39f8                 | push                ebx
            //   751c                 | mov                 ebx, eax
            //   8b4624               | add                 ebx, 2
            //   4801db               | movzx               eax, word ptr [ebx - 2]

        $sequence_9 = { 8d8b00030000 894c2408 8d4b08 894c2404 ff522c }
            // n = 5, score = 300
            //   8d8b00030000         | mov                 ebx, dword ptr [eax + 0x3c]
            //   894c2408             | xor                 edi, edi
            //   8d4b08               | sub                 esp, 0xc
            //   894c2404             | test                eax, eax
            //   ff522c               | jns                 0x2e2

    condition:
        7 of them and filesize < 81920
}