rule win_kazyloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kazyloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kazyloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { d2 9c 07 06 8e }
            // n = 5, score = 100
            //   d2                   | add                 byte ptr [edx], cl
            //   9c                   |                     
            //   07                   |                     
            //   06                   | pushfd              
            //   8e                   | pop                 es

        $sequence_1 = { 1309 1109 3a3fffffff 02 09 6f2700000a }
            // n = 6, score = 100
            //   1309                 | inc                 ebp
            //   1109                 | add                 eax, dword ptr [eax]
            //   3a3fffffff           | add                 byte ptr [eax], al
            //   02                   | inc                 ebp
            //   09                   | add                 byte ptr [eax], al
            //   6f2700000a           | add                 byte ptr [ecx], ch

        $sequence_2 = { 6f1a00000a 281b00000a 26 00 de00 }
            // n = 5, score = 100
            //   6f1a00000a           | or                  ebp, dword ptr [edi + 0x18]
            //   281b00000a           | add                 byte ptr [eax], al
            //   26                   | or                  dl, byte ptr [edi + edx]
            //   00                   | lea                 eax, [ecx]
            //   de00                 | add                 byte ptr [eax], al

        $sequence_3 = { 8e 69 58 280100002b }
            // n = 4, score = 100
            //   8e                   | or                  cl, byte ptr [edx]
            //   69                   | add                 ch, byte ptr [edi + 0x1f]
            //   58                   | add                 byte ptr [eax], al
            //   280100002b           | or                  dh, byte ptr [ecx + eax]

        $sequence_4 = { 00 08 16 06 06 8e 69 }
            // n = 7, score = 100
            //   00                   | pop                 es
            //   08                   | adc                 dword ptr [esi], eax
            //   16                   | xchg                eax, ecx
            //   06                   | outsd               dx, dword ptr [esi]
            //   06                   | add                 byte ptr es:[eax], al
            //   8e                   |                     
            //   69                   |                     

        $sequence_5 = { 00 1104 02 6f1f00000a 5a 1105 }
            // n = 6, score = 100
            //   00                   | or                  eax, dword ptr [edi]
            //   1104                 |                     
            //   02                   |                     
            //   6f1f00000a           |                     
            //   5a                   | outsd               dx, dword ptr [esi]
            //   1105                 | pop                 ds

        $sequence_6 = { 6f1400000a 740200001b 0c 1200 06 8e 69 }
            // n = 7, score = 100
            //   6f1400000a           | add                 al, byte ptr [eax]
            //   740200001b           | add                 byte ptr [esi], al
            //   0c                   | pop                 es
            //   1200                 | jae                 0x18
            //   06                   | add                 byte ptr [eax], al
            //   8e                   | outsd               dx, dword ptr [esi]
            //   69                   | adc                 al, 0

        $sequence_7 = { 58 91 1308 1108 20fd000000 59 }
            // n = 6, score = 100
            //   58                   |                     
            //   91                   |                     
            //   1308                 | push                ss
            //   1108                 | push                es
            //   20fd000000           | pop                 eax
            //   59                   | xchg                eax, ecx

        $sequence_8 = { 282100000a 00 02 08 19 02 6f2200000a }
            // n = 7, score = 100
            //   282100000a           | or                  cl, byte ptr [edx]
            //   00                   | push                es
            //   02                   | push                es
            //   08                   | add                 ebp, dword ptr [edi + 0x14]
            //   19                   | add                 byte ptr [eax], al
            //   02                   | sub                 byte ptr [esi], dl
            //   6f2200000a           | add                 byte ptr [eax], al

        $sequence_9 = { 07 04 2804000006 0b 07 281200000a 6f1800000a }
            // n = 7, score = 100
            //   07                   |                     
            //   04                   | pop                 es
            //   2804000006           |                     
            //   0b                   | sub                 byte ptr [eax + eax], al
            //   07                   | add                 byte ptr [esi], al
            //   281200000a           | or                  eax, dword ptr [edi]
            //   6f1800000a           | sub                 byte ptr [edx], dl

    condition:
        7 of them and filesize < 50176
}