rule win_kdcsponge_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kdcsponge."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kdcsponge"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 80fa01 751c 80bbc204000000 7709 80bbbc0400000f 740a c783a004000002000000 }
            // n = 7, score = 100
            //   80fa01               | add                 esp, 0x20
            //   751c                 | pop                 ebx
            //   80bbc204000000       | ret                 
            //   7709                 | cmp                 cl, 2
            //   80bbbc0400000f       | jne                 0x203c
            //   740a                 | dec                 eax
            //   c783a004000002000000     | add    dword ptr [ebx + 0x420], 2

        $sequence_1 = { 41b800100000 488d442440 48894c2448 4889442428 488d0d3bdd0200 4c89742420 ff15???????? }
            // n = 7, score = 100
            //   41b800100000         | ret                 
            //   488d442440           | mov                 eax, dword ptr [ecx + 0x43c]
            //   48894c2448           | mov                 dword ptr [ecx + 0x60], 0x10001
            //   4889442428           | mov                 dword ptr [ecx + 0x1f4], eax
            //   488d0d3bdd0200       | mov                 dword ptr [ecx + 0x2b0], eax
            //   4c89742420           | mov                 dword ptr [ecx + 0x36c], eax
            //   ff15????????         |                     

        $sequence_2 = { 894364 0fb601 488bcb ff14c2 83bb7804000010 750c d1bb44040000 }
            // n = 7, score = 100
            //   894364               | dec                 eax
            //   0fb601               | mov                 dword ptr [ebx + 0x214], 0x1000
            //   488bcb               | mov                 dword ptr [ebx + 0x1ec], 0x50
            //   ff14c2               | cmp                 eax, 0xe0
            //   83bb7804000010       | dec                 eax
            //   750c                 | mov                 eax, dword ptr [ecx + eax*8]
            //   d1bb44040000         | dec                 eax

        $sequence_3 = { 754d 83ba4404000020 7c0f c7826004000004000000 8d4804 eb0f c7826004000002000000 }
            // n = 7, score = 100
            //   754d                 | inc                 ecx
            //   83ba4404000020       | mov                 dword ptr [eax + 0x4a0], 0xfffffffe
            //   7c0f                 | ret                 
            //   c7826004000004000000     | dec    ecx
            //   8d4804               | mov                 eax, dword ptr [eax + 0x420]
            //   eb0f                 | mov                 ecx, dword ptr [eax + 3]
            //   c7826004000002000000     | dec    eax

        $sequence_4 = { 4883c8ff 807c030100 488d4001 75f5 448d4801 }
            // n = 5, score = 100
            //   4883c8ff             | cmp                 dl, al
            //   807c030100           | jne                 0x2bf
            //   488d4001             | mov                 byte ptr [ecx + 0x4c5], 0xe
            //   75f5                 | jne                 0x3c3
            //   448d4801             | and                 ecx, 0xf

        $sequence_5 = { 7514 4183b85004000004 750a 4180b8a604000000 740a 488d4201 488b5c2408 }
            // n = 7, score = 100
            //   7514                 | mov                 esi, edi
            //   4183b85004000004     | inc                 ecx
            //   750a                 | push                esi
            //   4180b8a604000000     | xor                 ebp, ebp
            //   740a                 | dec                 esp
            //   488d4201             | lea                 esi, [0xabf6]
            //   488b5c2408           | inc                 esp

        $sequence_6 = { 0fb64101 c1e806 898348040000 83f803 0f84d6000000 488d8b10010000 c7436000001900 }
            // n = 7, score = 100
            //   0fb64101             | mov                 dword ptr [ecx + 0x60], 0x60001
            //   c1e806               | jmp                 0x14b9
            //   898348040000         | cmp                 dword ptr [ecx + 0x484], 1
            //   83f803               | cmp                 dword ptr [ecx + 0x488], 1
            //   0f84d6000000         | jne                 0x1497
            //   488d8b10010000       | mov                 byte ptr [ecx + 0x40b], 8
            //   c7436000001900       | mov                 dword ptr [ecx + 0x440], 0x6d

        $sequence_7 = { 4053 4883ec20 80b9c304000001 488bd9 0f853d010000 80b9b004000001 0f850a020000 }
            // n = 7, score = 100
            //   4053                 | mov                 eax, 0x110000
            //   4883ec20             | mov                 ecx, 0x140000
            //   80b9c304000001       | mov                 dword ptr [ebx + 0x60], eax
            //   488bd9               | jmp                 0x17e1
            //   0f853d010000         | cmp                 al, 1
            //   80b9b004000001       | jne                 0x17bc
            //   0f850a020000         | cmp                 cl, 1

        $sequence_8 = { b800001100 b900001400 0f44c1 894360 7507 c683c504000005 488d8b10010000 }
            // n = 7, score = 100
            //   b800001100           | lea                 eax, [0x45ff1]
            //   b900001400           | dec                 eax
            //   0f44c1               | mov                 dword ptr [ecx], eax
            //   894360               | dec                 eax
            //   7507                 | mov                 ebx, ecx
            //   c683c504000005       | test                dl, 1
            //   488d8b10010000       | je                  0x1a50

        $sequence_9 = { e9???????? 33d2 418bcd 448d4201 e8???????? 488b542440 4c8d1ddb420100 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   33d2                 | jne                 0x14af
            //   418bcd               | cmp                 byte ptr [ecx + 0x4a4], 1
            //   448d4201             | jne                 0x1496
            //   e8????????           |                     
            //   488b542440           | je                  0x14cc
            //   4c8d1ddb420100       | mov                 dword ptr [ecx + 0x60], 0x10001

    condition:
        7 of them and filesize < 720896
}