rule win_kegotip_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kegotip."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kegotip"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb04 33c0 eb6d e9???????? eb63 }
            // n = 5, score = 600
            //   eb04                 | jmp                 6
            //   33c0                 | xor                 eax, eax
            //   eb6d                 | jmp                 0x6f
            //   e9????????           |                     
            //   eb63                 | jmp                 0x65

        $sequence_1 = { 85c9 740b 8b5508 0355f8 8955fc eb02 ebbb }
            // n = 7, score = 600
            //   85c9                 | test                ecx, ecx
            //   740b                 | je                  0xd
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   0355f8               | add                 edx, dword ptr [ebp - 8]
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   eb02                 | jmp                 4
            //   ebbb                 | jmp                 0xffffffbd

        $sequence_2 = { 8b450c 50 8d8df8feffff 51 e8???????? 83c408 c785a8fcffff80000000 }
            // n = 7, score = 600
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   50                   | push                eax
            //   8d8df8feffff         | lea                 ecx, [ebp - 0x108]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   c785a8fcffff80000000     | mov    dword ptr [ebp - 0x358], 0x80

        $sequence_3 = { 0f840c010000 6a00 6a00 6a03 6a00 6a00 6a50 }
            // n = 7, score = 600
            //   0f840c010000         | je                  0x112
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a03                 | push                3
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a50                 | push                0x50

        $sequence_4 = { 0fb64df7 85c9 7504 32c0 eb38 c645f700 }
            // n = 6, score = 600
            //   0fb64df7             | movzx               ecx, byte ptr [ebp - 9]
            //   85c9                 | test                ecx, ecx
            //   7504                 | jne                 6
            //   32c0                 | xor                 al, al
            //   eb38                 | jmp                 0x3a
            //   c645f700             | mov                 byte ptr [ebp - 9], 0

        $sequence_5 = { 3b5588 7d1e 8b4508 038578ffffff 0fbe4801 }
            // n = 5, score = 600
            //   3b5588               | cmp                 edx, dword ptr [ebp - 0x78]
            //   7d1e                 | jge                 0x20
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   038578ffffff         | add                 eax, dword ptr [ebp - 0x88]
            //   0fbe4801             | movsx               ecx, byte ptr [eax + 1]

        $sequence_6 = { ff5510 83c408 0fb6c8 85c9 7504 32c0 eb07 }
            // n = 7, score = 600
            //   ff5510               | call                dword ptr [ebp + 0x10]
            //   83c408               | add                 esp, 8
            //   0fb6c8               | movzx               ecx, al
            //   85c9                 | test                ecx, ecx
            //   7504                 | jne                 6
            //   32c0                 | xor                 al, al
            //   eb07                 | jmp                 9

        $sequence_7 = { 6a00 6800000080 8d95d8feffff 52 ff15???????? 8945e4 837de4ff }
            // n = 7, score = 600
            //   6a00                 | push                0
            //   6800000080           | push                0x80000000
            //   8d95d8feffff         | lea                 edx, [ebp - 0x128]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   837de4ff             | cmp                 dword ptr [ebp - 0x1c], -1

        $sequence_8 = { 32c0 e9???????? 68???????? e8???????? 83c404 68???????? }
            // n = 6, score = 600
            //   32c0                 | xor                 al, al
            //   e9????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   68????????           |                     

        $sequence_9 = { 3b4dfc 7324 8b5510 0355e4 8b45f4 0345f8 }
            // n = 6, score = 600
            //   3b4dfc               | cmp                 ecx, dword ptr [ebp - 4]
            //   7324                 | jae                 0x26
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   0355e4               | add                 edx, dword ptr [ebp - 0x1c]
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   0345f8               | add                 eax, dword ptr [ebp - 8]

    condition:
        7 of them and filesize < 278528
}