rule win_kelihos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kelihos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kelihos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 6a01 6a08 e8???????? 6a03 53 53 }
            // n = 7, score = 300
            //   e9????????           |                     
            //   6a01                 | push                1
            //   6a08                 | push                8
            //   e8????????           |                     
            //   6a03                 | push                3
            //   53                   | push                ebx
            //   53                   | push                ebx

        $sequence_1 = { e8???????? 8bf3 8d5c1b02 3b5d0c 7cb6 7526 8b450c }
            // n = 7, score = 300
            //   e8????????           |                     
            //   8bf3                 | mov                 esi, ebx
            //   8d5c1b02             | lea                 ebx, [ebx + ebx + 2]
            //   3b5d0c               | cmp                 ebx, dword ptr [ebp + 0xc]
            //   7cb6                 | jl                  0xffffffb8
            //   7526                 | jne                 0x28
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_2 = { 8d8c24ac000000 8844241b e8???????? 85c0 743a 385c2417 7534 }
            // n = 7, score = 300
            //   8d8c24ac000000       | lea                 ecx, [esp + 0xac]
            //   8844241b             | mov                 byte ptr [esp + 0x1b], al
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   743a                 | je                  0x3c
            //   385c2417             | cmp                 byte ptr [esp + 0x17], bl
            //   7534                 | jne                 0x36

        $sequence_3 = { c3 837c2404ff 750e 817c2408ffffff7f 7504 33c0 40 }
            // n = 7, score = 300
            //   c3                   | ret                 
            //   837c2404ff           | cmp                 dword ptr [esp + 4], -1
            //   750e                 | jne                 0x10
            //   817c2408ffffff7f     | cmp                 dword ptr [esp + 8], 0x7fffffff
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax

        $sequence_4 = { c60060 e8???????? 6a5c 8bce c60064 e8???????? 68c5010000 }
            // n = 7, score = 300
            //   c60060               | mov                 byte ptr [eax], 0x60
            //   e8????????           |                     
            //   6a5c                 | push                0x5c
            //   8bce                 | mov                 ecx, esi
            //   c60064               | mov                 byte ptr [eax], 0x64
            //   e8????????           |                     
            //   68c5010000           | push                0x1c5

        $sequence_5 = { eb02 33c0 57 50 ff742418 ff742420 ff74241c }
            // n = 7, score = 300
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   57                   | push                edi
            //   50                   | push                eax
            //   ff742418             | push                dword ptr [esp + 0x18]
            //   ff742420             | push                dword ptr [esp + 0x20]
            //   ff74241c             | push                dword ptr [esp + 0x1c]

        $sequence_6 = { c3 56 8bf1 6a00 6a01 8d4e7c c706???????? }
            // n = 7, score = 300
            //   c3                   | ret                 
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   8d4e7c               | lea                 ecx, [esi + 0x7c]
            //   c706????????         |                     

        $sequence_7 = { e9???????? e8???????? 8b00 50 e8???????? 83c404 50 }
            // n = 7, score = 300
            //   e9????????           |                     
            //   e8????????           |                     
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   50                   | push                eax

        $sequence_8 = { c6400d00 8908 eb06 8b4508 832000 e8???????? c20c00 }
            // n = 7, score = 300
            //   c6400d00             | mov                 byte ptr [eax + 0xd], 0
            //   8908                 | mov                 dword ptr [eax], ecx
            //   eb06                 | jmp                 8
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   832000               | and                 dword ptr [eax], 0
            //   e8????????           |                     
            //   c20c00               | ret                 0xc

        $sequence_9 = { c1e108 034df0 8d4514 e8???????? 834dfcff 8d4514 50 }
            // n = 7, score = 300
            //   c1e108               | shl                 ecx, 8
            //   034df0               | add                 ecx, dword ptr [ebp - 0x10]
            //   8d4514               | lea                 eax, [ebp + 0x14]
            //   e8????????           |                     
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff
            //   8d4514               | lea                 eax, [ebp + 0x14]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 4702208
}