rule win_kerrdown_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kerrdown."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kerrdown"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85f6 743f 83ff10 b8???????? 0f43c1 85f6 }
            // n = 6, score = 200
            //   85f6                 | test                esi, esi
            //   743f                 | je                  0x41
            //   83ff10               | cmp                 edi, 0x10
            //   b8????????           |                     
            //   0f43c1               | cmovae              eax, ecx
            //   85f6                 | test                esi, esi

        $sequence_1 = { 8d45f8 50 68004a0000 68???????? }
            // n = 4, score = 200
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   68004a0000           | push                0x4a00
            //   68????????           |                     

        $sequence_2 = { 741b 56 68???????? 50 e8???????? }
            // n = 5, score = 200
            //   741b                 | je                  0x1d
            //   56                   | push                esi
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_3 = { 75b2 83ff10 8935???????? b8???????? 0f43c1 5e }
            // n = 6, score = 200
            //   75b2                 | jne                 0xffffffb4
            //   83ff10               | cmp                 edi, 0x10
            //   8935????????         |                     
            //   b8????????           |                     
            //   0f43c1               | cmovae              eax, ecx
            //   5e                   | pop                 esi

        $sequence_4 = { 5f 85c0 7543 50 6880000000 }
            // n = 5, score = 200
            //   5f                   | pop                 edi
            //   85c0                 | test                eax, eax
            //   7543                 | jne                 0x45
            //   50                   | push                eax
            //   6880000000           | push                0x80

        $sequence_5 = { 8bd3 2bd6 8a0e 8d7601 }
            // n = 4, score = 200
            //   8bd3                 | mov                 edx, ebx
            //   2bd6                 | sub                 edx, esi
            //   8a0e                 | mov                 cl, byte ptr [esi]
            //   8d7601               | lea                 esi, [esi + 1]

        $sequence_6 = { 8935???????? b8???????? 0f43c1 5e }
            // n = 4, score = 200
            //   8935????????         |                     
            //   b8????????           |                     
            //   0f43c1               | cmovae              eax, ecx
            //   5e                   | pop                 esi

        $sequence_7 = { 884de5 02c2 33f6 8845e6 0fb64435e4 50 }
            // n = 6, score = 200
            //   884de5               | mov                 byte ptr [ebp - 0x1b], cl
            //   02c2                 | add                 al, dl
            //   33f6                 | xor                 esi, esi
            //   8845e6               | mov                 byte ptr [ebp - 0x1a], al
            //   0fb64435e4           | movzx               eax, byte ptr [ebp + esi - 0x1c]
            //   50                   | push                eax

        $sequence_8 = { b8???????? 0f43c1 03c2 3d???????? 762a ff750c 83ff10 }
            // n = 7, score = 200
            //   b8????????           |                     
            //   0f43c1               | cmovae              eax, ecx
            //   03c2                 | add                 eax, edx
            //   3d????????           |                     
            //   762a                 | jbe                 0x2c
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   83ff10               | cmp                 edi, 0x10

        $sequence_9 = { 80e203 c0e004 02d1 8855e4 8a55ea 8aca }
            // n = 6, score = 200
            //   80e203               | and                 dl, 3
            //   c0e004               | shl                 al, 4
            //   02d1                 | add                 dl, cl
            //   8855e4               | mov                 byte ptr [ebp - 0x1c], dl
            //   8a55ea               | mov                 dl, byte ptr [ebp - 0x16]
            //   8aca                 | mov                 cl, dl

    condition:
        7 of them and filesize < 278528
}