rule win_ketrican_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ketrican."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ketrican"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8965f0 33db 895dfc 33c0 }
            // n = 4, score = 700
            //   8965f0               | mov                 dword ptr [ebp - 0x10], esp
            //   33db                 | xor                 ebx, ebx
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { 5e c3 55 8bec 837d0800 7d0a }
            // n = 6, score = 600
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   7d0a                 | jge                 0xc

        $sequence_2 = { 8bc1 8945f0 834dfcff e8???????? }
            // n = 4, score = 600
            //   8bc1                 | mov                 eax, ecx
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff
            //   e8????????           |                     

        $sequence_3 = { e8???????? 83c010 8906 c3 56 8bf1 57 }
            // n = 7, score = 600
            //   e8????????           |                     
            //   83c010               | add                 eax, 0x10
            //   8906                 | mov                 dword ptr [esi], eax
            //   c3                   | ret                 
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   57                   | push                edi

        $sequence_4 = { 5f 5e 8901 5b 5d c20800 680e000780 }
            // n = 7, score = 600
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   8901                 | mov                 dword ptr [ecx], eax
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8
            //   680e000780           | push                0x8007000e

        $sequence_5 = { 7417 6a0a 6a1f 68???????? }
            // n = 4, score = 600
            //   7417                 | je                  0x19
            //   6a0a                 | push                0xa
            //   6a1f                 | push                0x1f
            //   68????????           |                     

        $sequence_6 = { e8???????? cc 8b06 83e810 8b08 395008 }
            // n = 6, score = 600
            //   e8????????           |                     
            //   cc                   | int3                
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   83e810               | sub                 eax, 0x10
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   395008               | cmp                 dword ptr [eax + 8], edx

        $sequence_7 = { e8???????? 8b06 5d c20400 55 8bec 8b4508 }
            // n = 7, score = 600
            //   e8????????           |                     
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_8 = { 8bc7 c1e810 83e03f e8???????? }
            // n = 4, score = 500
            //   8bc7                 | mov                 eax, edi
            //   c1e810               | shr                 eax, 0x10
            //   83e03f               | and                 eax, 0x3f
            //   e8????????           |                     

        $sequence_9 = { 2bc6 8b35???????? 53 8bf8 57 }
            // n = 5, score = 500
            //   2bc6                 | sub                 eax, esi
            //   8b35????????         |                     
            //   53                   | push                ebx
            //   8bf8                 | mov                 edi, eax
            //   57                   | push                edi

        $sequence_10 = { 8bec 8b4508 53 56 57 8d7001 33db }
            // n = 7, score = 500
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8d7001               | lea                 esi, [eax + 1]
            //   33db                 | xor                 ebx, ebx

        $sequence_11 = { 56 8d4806 57 e8???????? 83c414 8bf0 }
            // n = 6, score = 500
            //   56                   | push                esi
            //   8d4806               | lea                 ecx, [eax + 6]
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   8bf0                 | mov                 esi, eax

        $sequence_12 = { 83c604 8345f804 8b45f8 5f c60600 5e }
            // n = 6, score = 500
            //   83c604               | add                 esi, 4
            //   8345f804             | add                 dword ptr [ebp - 8], 4
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   5f                   | pop                 edi
            //   c60600               | mov                 byte ptr [esi], 0
            //   5e                   | pop                 esi

        $sequence_13 = { 7706 8a4405bc c9 c3 }
            // n = 4, score = 500
            //   7706                 | ja                  8
            //   8a4405bc             | mov                 al, byte ptr [ebp + eax - 0x44]
            //   c9                   | leave               
            //   c3                   | ret                 

        $sequence_14 = { eb1f 68???????? e8???????? a3???????? }
            // n = 4, score = 500
            //   eb1f                 | jmp                 0x21
            //   68????????           |                     
            //   e8????????           |                     
            //   a3????????           |                     

        $sequence_15 = { 8b8a8c2f0000 33c8 e8???????? b8???????? e9???????? }
            // n = 5, score = 100
            //   8b8a8c2f0000         | mov                 ecx, dword ptr [edx + 0x2f8c]
            //   33c8                 | xor                 ecx, eax
            //   e8????????           |                     
            //   b8????????           |                     
            //   e9????????           |                     

        $sequence_16 = { b8???????? e9???????? 8b542408 8d420c 8b8aecfdffff 33c8 e8???????? }
            // n = 7, score = 100
            //   b8????????           |                     
            //   e9????????           |                     
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   8d420c               | lea                 eax, [edx + 0xc]
            //   8b8aecfdffff         | mov                 ecx, dword ptr [edx - 0x214]
            //   33c8                 | xor                 ecx, eax
            //   e8????????           |                     

        $sequence_17 = { e9???????? c705????????ac824100 c3 b9???????? e9???????? }
            // n = 5, score = 100
            //   e9????????           |                     
            //   c705????????ac824100     |     
            //   c3                   | ret                 
            //   b9????????           |                     
            //   e9????????           |                     

        $sequence_18 = { e9???????? 8d45d0 e9???????? 8d4dd0 }
            // n = 4, score = 100
            //   e9????????           |                     
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   e9????????           |                     
            //   8d4dd0               | lea                 ecx, [ebp - 0x30]

        $sequence_19 = { e9???????? 8b4508 e9???????? 8b45ec 83e001 0f840c000000 8365ecfe }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   e9????????           |                     
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   83e001               | and                 eax, 1
            //   0f840c000000         | je                  0x12
            //   8365ecfe             | and                 dword ptr [ebp - 0x14], 0xfffffffe

        $sequence_20 = { e9???????? 8d4dd0 e9???????? 8d4de0 e9???????? 8d4db8 e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8d4dd0               | lea                 ecx, [ebp - 0x30]
            //   e9????????           |                     
            //   8d4de0               | lea                 ecx, [ebp - 0x20]
            //   e9????????           |                     
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   e9????????           |                     

        $sequence_21 = { e9???????? 8d4ddc e9???????? 8b45d4 83e001 }
            // n = 5, score = 100
            //   e9????????           |                     
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   e9????????           |                     
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   83e001               | and                 eax, 1

        $sequence_22 = { 8365d4fe 8d4da4 e9???????? c3 8d4dbc e9???????? }
            // n = 6, score = 100
            //   8365d4fe             | and                 dword ptr [ebp - 0x2c], 0xfffffffe
            //   8d4da4               | lea                 ecx, [ebp - 0x5c]
            //   e9????????           |                     
            //   c3                   | ret                 
            //   8d4dbc               | lea                 ecx, [ebp - 0x44]
            //   e9????????           |                     

    condition:
        7 of them and filesize < 1449984
}