rule win_ketrum_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ketrum."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ketrum"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8a08 40 3acb 75f9 52 ff74241c 2bc7 }
            // n = 7, score = 200
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   40                   | inc                 eax
            //   3acb                 | cmp                 cl, bl
            //   75f9                 | jne                 0xfffffffb
            //   52                   | push                edx
            //   ff74241c             | push                dword ptr [esp + 0x1c]
            //   2bc7                 | sub                 eax, edi

        $sequence_1 = { 6a00 50 e8???????? 8d85fcefffff 83c418 }
            // n = 5, score = 200
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d85fcefffff         | lea                 eax, [ebp - 0x1004]
            //   83c418               | add                 esp, 0x18

        $sequence_2 = { 8bf7 83e61f c1e606 033485a0bc6200 c745e401000000 }
            // n = 5, score = 200
            //   8bf7                 | mov                 esi, edi
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6
            //   033485a0bc6200       | add                 esi, dword ptr [eax*4 + 0x62bca0]
            //   c745e401000000       | mov                 dword ptr [ebp - 0x1c], 1

        $sequence_3 = { 68???????? 50 ffd7 83c43c 53 53 }
            // n = 6, score = 200
            //   68????????           |                     
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   83c43c               | add                 esp, 0x3c
            //   53                   | push                ebx
            //   53                   | push                ebx

        $sequence_4 = { 85c0 7549 ff15???????? 8bf0 56 68???????? }
            // n = 6, score = 200
            //   85c0                 | test                eax, eax
            //   7549                 | jne                 0x4b
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   56                   | push                esi
            //   68????????           |                     

        $sequence_5 = { ba???????? 898df0d3ffff 3bc7 7321 8995f0d3ffff }
            // n = 5, score = 200
            //   ba????????           |                     
            //   898df0d3ffff         | mov                 dword ptr [ebp - 0x2c10], ecx
            //   3bc7                 | cmp                 eax, edi
            //   7321                 | jae                 0x23
            //   8995f0d3ffff         | mov                 dword ptr [ebp - 0x2c10], edx

        $sequence_6 = { 894dd4 8945d8 eb06 215dd4 215dd8 }
            // n = 5, score = 200
            //   894dd4               | mov                 dword ptr [ebp - 0x2c], ecx
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   eb06                 | jmp                 8
            //   215dd4               | and                 dword ptr [ebp - 0x2c], ebx
            //   215dd8               | and                 dword ptr [ebp - 0x28], ebx

        $sequence_7 = { 58 b9???????? e8???????? 59 57 68???????? e8???????? }
            // n = 7, score = 200
            //   58                   | pop                 eax
            //   b9????????           |                     
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   57                   | push                edi
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_8 = { 68???????? 50 ff15???????? ffb534fdffff 8d8de0fdffff ffb52cfdffff e8???????? }
            // n = 7, score = 100
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ffb534fdffff         | push                dword ptr [ebp - 0x2cc]
            //   8d8de0fdffff         | lea                 ecx, [ebp - 0x220]
            //   ffb52cfdffff         | push                dword ptr [ebp - 0x2d4]
            //   e8????????           |                     

        $sequence_9 = { 68???????? 8d4da8 e8???????? 59 84c0 }
            // n = 5, score = 100
            //   68????????           |                     
            //   8d4da8               | lea                 ecx, [ebp - 0x58]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   84c0                 | test                al, al

        $sequence_10 = { e8???????? 8b450c 8b5d08 33c9 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   33c9                 | xor                 ecx, ecx

        $sequence_11 = { ff15???????? 898350010000 80bd33efffff00 0f84e3f2ffff }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   898350010000         | mov                 dword ptr [ebx + 0x150], eax
            //   80bd33efffff00       | cmp                 byte ptr [ebp - 0x10cd], 0
            //   0f84e3f2ffff         | je                  0xfffff2e9

        $sequence_12 = { 7503 6a09 59 66890e eb03 668916 830002 }
            // n = 7, score = 100
            //   7503                 | jne                 5
            //   6a09                 | push                9
            //   59                   | pop                 ecx
            //   66890e               | mov                 word ptr [esi], cx
            //   eb03                 | jmp                 5
            //   668916               | mov                 word ptr [esi], dx
            //   830002               | add                 dword ptr [eax], 2

        $sequence_13 = { 898d34efffff 6a00 ffb534efffff 83c8ff }
            // n = 4, score = 100
            //   898d34efffff         | mov                 dword ptr [ebp - 0x10cc], ecx
            //   6a00                 | push                0
            //   ffb534efffff         | push                dword ptr [ebp - 0x10cc]
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_14 = { 50 8db578fdffff e8???????? 8bc6 50 8d85a0fbffff 50 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8db578fdffff         | lea                 esi, [ebp - 0x288]
            //   e8????????           |                     
            //   8bc6                 | mov                 eax, esi
            //   50                   | push                eax
            //   8d85a0fbffff         | lea                 eax, [ebp - 0x460]
            //   50                   | push                eax

        $sequence_15 = { 8d458c 50 c645fc03 e8???????? 59 }
            // n = 5, score = 100
            //   8d458c               | lea                 eax, [ebp - 0x74]
            //   50                   | push                eax
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   e8????????           |                     
            //   59                   | pop                 ecx

    condition:
        7 of them and filesize < 4599808
}