rule win_keymarble_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.keymarble."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.keymarble"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 50 e8???????? 83c404 56 6a40 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   56                   | push                esi
            //   6a40                 | push                0x40

        $sequence_1 = { 6a00 6a03 6800000040 57 ffd6 }
            // n = 5, score = 200
            //   6a00                 | push                0
            //   6a03                 | push                3
            //   6800000040           | push                0x40000000
            //   57                   | push                edi
            //   ffd6                 | call                esi

        $sequence_2 = { ff15???????? e8???????? 99 b907000000 f7f9 }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   e8????????           |                     
            //   99                   | cdq                 
            //   b907000000           | mov                 ecx, 7
            //   f7f9                 | idiv                ecx

        $sequence_3 = { e8???????? 83c408 85c0 7407 bb7a452301 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   bb7a452301           | mov                 ebx, 0x123457a

        $sequence_4 = { ffd7 50 e8???????? 83c404 e8???????? 8d3470 81e6ffffff7f }
            // n = 7, score = 200
            //   ffd7                 | call                edi
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   e8????????           |                     
            //   8d3470               | lea                 esi, [eax + esi*2]
            //   81e6ffffff7f         | and                 esi, 0x7fffffff

        $sequence_5 = { e9???????? 50 6a00 6810040000 }
            // n = 4, score = 200
            //   e9????????           |                     
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6810040000           | push                0x410

        $sequence_6 = { 85db 7407 53 ff15???????? ff15???????? }
            // n = 5, score = 200
            //   85db                 | test                ebx, ebx
            //   7407                 | je                  9
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   ff15????????         |                     

        $sequence_7 = { e9???????? 50 6a00 6810040000 ff15???????? }
            // n = 5, score = 200
            //   e9????????           |                     
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6810040000           | push                0x410
            //   ff15????????         |                     

        $sequence_8 = { ff15???????? 85db 7407 53 ff15???????? ff15???????? }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   85db                 | test                ebx, ebx
            //   7407                 | je                  9
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   ff15????????         |                     

        $sequence_9 = { 50 e8???????? 83c404 e8???????? 8d3470 81e6ffffff7f }
            // n = 6, score = 200
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   e8????????           |                     
            //   8d3470               | lea                 esi, [eax + esi*2]
            //   81e6ffffff7f         | and                 esi, 0x7fffffff

    condition:
        7 of them and filesize < 1146880
}