rule win_kgh_spy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kgh_spy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kgh_spy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 488b8c24a0000000 ff15???????? 0fb605???????? 88842480010000 488d842481010000 488bf8 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   488b8c24a0000000     | lea                 ecx, [esp + 0xc0]
            //   ff15????????         |                     
            //   0fb605????????       |                     
            //   88842480010000       | dec                 esp
            //   488d842481010000     | lea                 eax, [esp + 0xb4]
            //   488bf8               | dec                 eax

        $sequence_1 = { 488d0dd0fd0000 e8???????? c744244000000000 c744244800000000 488d442460 488d0def150100 488bf8 }
            // n = 7, score = 100
            //   488d0dd0fd0000       | mov                 ecx, dword ptr [esp + 0x20]
            //   e8????????           |                     
            //   c744244000000000     | jne                 0xc81
            //   c744244800000000     | xor                 al, al
            //   488d442460           | dec                 eax
            //   488d0def150100       | lea                 ecx, [0xec9d]
            //   488bf8               | dec                 eax

        $sequence_2 = { ff15???????? 4889442468 48837c246800 7507 32c0 e9???????? 48c744243800000000 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   4889442468           | dec                 esp
            //   48837c246800         | lea                 eax, [esp + 0xb4]
            //   7507                 | dec                 eax
            //   32c0                 | lea                 edx, [0xe5b8]
            //   e9????????           |                     
            //   48c744243800000000     | dec    eax

        $sequence_3 = { 448d4202 e8???????? 8bcb e8???????? 85c0 0f84bc020000 488d0517bf0000 }
            // n = 7, score = 100
            //   448d4202             | lea                 edx, [esp + 0xe30]
            //   e8????????           |                     
            //   8bcb                 | dec                 eax
            //   e8????????           |                     
            //   85c0                 | lea                 ecx, [0x11990]
            //   0f84bc020000         | mov                 edx, 1
            //   488d0517bf0000       | xor                 ecx, ecx

        $sequence_4 = { 75eb 488b442430 488b8c2490000000 4803c8 488bc1 }
            // n = 5, score = 100
            //   75eb                 | dec                 eax
            //   488b442430           | mov                 ecx, eax
            //   488b8c2490000000     | dec                 eax
            //   4803c8               | mov                 eax, ecx
            //   488bc1               | dec                 esp

        $sequence_5 = { e8???????? 488905???????? 48833d????????00 7504 32c0 eb26 ba855d05a6 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488905????????       |                     
            //   48833d????????00     |                     
            //   7504                 | and                 ecx, 0x1f
            //   32c0                 | dec                 eax
            //   eb26                 | mov                 eax, dword ptr [edx + eax*8]
            //   ba855d05a6           | dec                 eax

        $sequence_6 = { 488d8424f0030000 488bf8 33c0 b908020000 f3aa 4c8d0df7e30000 }
            // n = 6, score = 100
            //   488d8424f0030000     | cmp                 dword ptr [esp + 0x20], 0
            //   488bf8               | jne                 0x113e
            //   33c0                 | xor                 al, al
            //   b908020000           | mov                 edx, 0x73073de7
            //   f3aa                 | dec                 eax
            //   4c8d0df7e30000       | mov                 ecx, dword ptr [esp + 0x20]

        $sequence_7 = { 89442428 488d8424300e0000 4889442420 448bc9 4c8d8424300a0000 }
            // n = 5, score = 100
            //   89442428             | mov                 ecx, eax
            //   488d8424300e0000     | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   4889442420           | dec                 eax
            //   448bc9               | mov                 eax, dword ptr [esp + 0x40]
            //   4c8d8424300a0000     | dec                 eax

        $sequence_8 = { 488b442428 8b4c2430 894808 4863442424 4889442440 488b7c2430 33c0 }
            // n = 7, score = 100
            //   488b442428           | dec                 eax
            //   8b4c2430             | lea                 edx, [esp + 0x360]
            //   894808               | mov                 ecx, 0x104
            //   4863442424           | dec                 esp
            //   4889442440           | lea                 ecx, [0xbe09]
            //   488b7c2430           | xor                 eax, eax
            //   33c0                 | mov                 ecx, 0x103

        $sequence_9 = { ff15???????? 0fb605???????? 888424a0030000 488d8424a1030000 488bf8 33c0 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   0fb605????????       |                     
            //   888424a0030000       | lea                 eax, [0xe40f]
            //   488d8424a1030000     | dec                 eax
            //   488bf8               | mov                 dword ptr [esp + 0x78], eax
            //   33c0                 | jmp                 0xf6e

    condition:
        7 of them and filesize < 207872
}