rule win_kikothac_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kikothac."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kikothac"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 668945de e8???????? 83f8ff 0f84c2000000 803d????????00 }
            // n = 5, score = 200
            //   668945de             | mov                 word ptr [ebp - 0x22], ax
            //   e8????????           |                     
            //   83f8ff               | cmp                 eax, -1
            //   0f84c2000000         | je                  0xc8
            //   803d????????00       |                     

        $sequence_1 = { 80ce63 3485 80f601 041b 660fbdd0 }
            // n = 5, score = 200
            //   80ce63               | or                  dh, 0x63
            //   3485                 | xor                 al, 0x85
            //   80f601               | xor                 dh, 1
            //   041b                 | add                 al, 0x1b
            //   660fbdd0             | bsr                 dx, ax

        $sequence_2 = { 8b140e 52 8d5dfc e8???????? 83c404 84c0 7509 }
            // n = 7, score = 200
            //   8b140e               | mov                 edx, dword ptr [esi + ecx]
            //   52                   | push                edx
            //   8d5dfc               | lea                 ebx, [ebp - 4]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   84c0                 | test                al, al
            //   7509                 | jne                 0xb

        $sequence_3 = { 57 8bc2 c1f805 8b0485c0514100 8bfa 83e71f }
            // n = 6, score = 200
            //   57                   | push                edi
            //   8bc2                 | mov                 eax, edx
            //   c1f805               | sar                 eax, 5
            //   8b0485c0514100       | mov                 eax, dword ptr [eax*4 + 0x4151c0]
            //   8bfa                 | mov                 edi, edx
            //   83e71f               | and                 edi, 0x1f

        $sequence_4 = { 660fbae309 8a46ff c1da07 f6c3a7 28d8 51 }
            // n = 6, score = 200
            //   660fbae309           | bt                  bx, 9
            //   8a46ff               | mov                 al, byte ptr [esi - 1]
            //   c1da07               | rcr                 edx, 7
            //   f6c3a7               | test                bl, 0xa7
            //   28d8                 | sub                 al, bl
            //   51                   | push                ecx

        $sequence_5 = { 5b 8b7708 8b7f04 84c0 751a e8???????? 84c0 }
            // n = 7, score = 200
            //   5b                   | pop                 ebx
            //   8b7708               | mov                 esi, dword ptr [edi + 8]
            //   8b7f04               | mov                 edi, dword ptr [edi + 4]
            //   84c0                 | test                al, al
            //   751a                 | jne                 0x1c
            //   e8????????           |                     
            //   84c0                 | test                al, al

        $sequence_6 = { f5 f6d8 9c 28c3 f9 }
            // n = 5, score = 200
            //   f5                   | cmc                 
            //   f6d8                 | neg                 al
            //   9c                   | pushfd              
            //   28c3                 | sub                 bl, al
            //   f9                   | stc                 

        $sequence_7 = { 8b4df4 03c2 668b55f8 8908 8a4dfa 66895004 884806 }
            // n = 7, score = 200
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   03c2                 | add                 eax, edx
            //   668b55f8             | mov                 dx, word ptr [ebp - 8]
            //   8908                 | mov                 dword ptr [eax], ecx
            //   8a4dfa               | mov                 cl, byte ptr [ebp - 6]
            //   66895004             | mov                 word ptr [eax + 4], dx
            //   884806               | mov                 byte ptr [eax + 6], cl

        $sequence_8 = { c64424080e 50 38c6 98 }
            // n = 4, score = 200
            //   c64424080e           | mov                 byte ptr [esp + 8], 0xe
            //   50                   | push                eax
            //   38c6                 | cmp                 dh, al
            //   98                   | cwde                

        $sequence_9 = { 660fb6f3 8db30307ad85 c744244800000000 8db7ec8bddf1 8b742474 9c ff3424 }
            // n = 7, score = 200
            //   660fb6f3             | movzx               si, bl
            //   8db30307ad85         | lea                 esi, [ebx - 0x7a52f8fd]
            //   c744244800000000     | mov                 dword ptr [esp + 0x48], 0
            //   8db7ec8bddf1         | lea                 esi, [edi - 0xe227414]
            //   8b742474             | mov                 esi, dword ptr [esp + 0x74]
            //   9c                   | pushfd              
            //   ff3424               | push                dword ptr [esp]

    condition:
        7 of them and filesize < 581632
}