rule win_kimsuky_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kimsuky."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kimsuky"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d85f8feffff 6804010000 50 e8???????? 8d85f0fcffff }
            // n = 5, score = 400
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]
            //   6804010000           | push                0x104
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d85f0fcffff         | lea                 eax, [ebp - 0x310]

        $sequence_1 = { ffd7 a3???????? 8d85ecfbffff 50 53 ffd7 }
            // n = 6, score = 400
            //   ffd7                 | call                edi
            //   a3????????           |                     
            //   8d85ecfbffff         | lea                 eax, [ebp - 0x414]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   ffd7                 | call                edi

        $sequence_2 = { 6a00 6800f70484 6a00 6a00 68???????? 8d85e4fbffff 50 }
            // n = 7, score = 400
            //   6a00                 | push                0
            //   6800f70484           | push                0x8404f700
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   68????????           |                     
            //   8d85e4fbffff         | lea                 eax, [ebp - 0x41c]
            //   50                   | push                eax

        $sequence_3 = { ff15???????? 3db7000000 7503 56 eb18 6a00 }
            // n = 6, score = 400
            //   ff15????????         |                     
            //   3db7000000           | cmp                 eax, 0xb7
            //   7503                 | jne                 5
            //   56                   | push                esi
            //   eb18                 | jmp                 0x1a
            //   6a00                 | push                0

        $sequence_4 = { 8d95f0fcffff b9???????? e8???????? 8d95ecfbffff b9???????? }
            // n = 5, score = 400
            //   8d95f0fcffff         | lea                 edx, [ebp - 0x310]
            //   b9????????           |                     
            //   e8????????           |                     
            //   8d95ecfbffff         | lea                 edx, [ebp - 0x414]
            //   b9????????           |                     

        $sequence_5 = { ff15???????? 8d85ecfbffff 50 8d85f8feffff 50 8d85f4fdffff 68???????? }
            // n = 7, score = 400
            //   ff15????????         |                     
            //   8d85ecfbffff         | lea                 eax, [ebp - 0x414]
            //   50                   | push                eax
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]
            //   50                   | push                eax
            //   8d85f4fdffff         | lea                 eax, [ebp - 0x20c]
            //   68????????           |                     

        $sequence_6 = { e8???????? 83c418 8d85f8feffff 6a00 50 ff15???????? 8d85ecfbffff }
            // n = 7, score = 400
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d85ecfbffff         | lea                 eax, [ebp - 0x414]

        $sequence_7 = { ff15???????? 85c0 7516 ff15???????? 8bd8 e8???????? }
            // n = 6, score = 400
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7516                 | jne                 0x18
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   e8????????           |                     

        $sequence_8 = { ffd7 a3???????? 8d85d4f5ffff 50 }
            // n = 4, score = 400
            //   ffd7                 | call                edi
            //   a3????????           |                     
            //   8d85d4f5ffff         | lea                 eax, [ebp - 0xa2c]
            //   50                   | push                eax

        $sequence_9 = { 8b4520 4883c514 85c0 0f857affffff 4c8b7c2460 4c8b6c2420 4c8b642428 }
            // n = 7, score = 300
            //   8b4520               | inc                 ecx
            //   4883c514             | push                esi
            //   85c0                 | inc                 ecx
            //   0f857affffff         | push                edi
            //   4c8b7c2460           | dec                 eax
            //   4c8b6c2420           | sub                 esp, 0x40
            //   4c8b642428           | dec                 eax

        $sequence_10 = { 4156 4157 4883ec40 48896c2470 }
            // n = 4, score = 300
            //   4156                 | dec                 eax
            //   4157                 | mov                 dword ptr [esp + 0x30], edi
            //   4883ec40             | dec                 eax
            //   48896c2470           | mov                 dword ptr [esp + 0x60], ebp

        $sequence_11 = { 48896c2460 488b4818 41bb01000000 4c8b7120 4d85f6 }
            // n = 5, score = 300
            //   48896c2460           | dec                 esp
            //   488b4818             | mov                 edi, dword ptr [esp + 0x60]
            //   41bb01000000         | dec                 esp
            //   4c8b7120             | mov                 ebp, dword ptr [esp + 0x20]
            //   4d85f6               | dec                 esp

        $sequence_12 = { 33d2 4883c9ff 4903de ff542468 4533c0 498bce }
            // n = 6, score = 300
            //   33d2                 | mov                 dword ptr [esp + 0x70], ebp
            //   4883c9ff             | mov                 eax, dword ptr [ebp + 0x20]
            //   4903de               | dec                 eax
            //   ff542468             | add                 ebp, 0x14
            //   4533c0               | test                eax, eax
            //   498bce               | jne                 0xffffff86

        $sequence_13 = { 488b6c2460 4c637d3c 33c9 41b800300000 4c03fd 448d4940 }
            // n = 6, score = 300
            //   488b6c2460           | dec                 eax
            //   4c637d3c             | mov                 ecx, dword ptr [eax + 0x18]
            //   33c9                 | inc                 ecx
            //   41b800300000         | mov                 ebx, 1
            //   4c03fd               | dec                 esp
            //   448d4940             | mov                 esi, dword ptr [ecx + 0x20]

        $sequence_14 = { 48896c2470 4889742438 4533ff 4c89642428 4c896c2420 33f6 }
            // n = 6, score = 300
            //   48896c2470           | mov                 esp, dword ptr [esp + 0x28]
            //   4889742438           | xor                 edx, edx
            //   4533ff               | dec                 eax
            //   4c89642428           | or                  ecx, 0xffffffff
            //   4c896c2420           | dec                 ecx
            //   33f6                 | add                 ebx, esi

        $sequence_15 = { 7405 48ffcd ebdb 65488b042560000000 48897c2430 48896c2460 }
            // n = 6, score = 300
            //   7405                 | je                  7
            //   48ffcd               | dec                 eax
            //   ebdb                 | dec                 ebp
            //   65488b042560000000     | jmp    0xffffffdd
            //   48897c2430           | dec                 eax
            //   48896c2460           | mov                 eax, dword ptr [0x60]

        $sequence_16 = { 85c9 0f8494020000 89bda0000000 897d30 }
            // n = 4, score = 200
            //   85c9                 | mov                 dword ptr [esp + 0x70], ebp
            //   0f8494020000         | dec                 eax
            //   89bda0000000         | sub                 esp, 0x40
            //   897d30               | dec                 eax

        $sequence_17 = { 89442450 8bf0 8bc8 e8???????? }
            // n = 4, score = 200
            //   89442450             | dec                 eax
            //   8bf0                 | sub                 esp, 0x40
            //   8bc8                 | dec                 eax
            //   e8????????           |                     

        $sequence_18 = { 85c0 0f84b3000000 85f6 0f8497000000 }
            // n = 4, score = 200
            //   85c0                 | inc                 ecx
            //   0f84b3000000         | push                esi
            //   85f6                 | inc                 ecx
            //   0f8497000000         | push                edi

        $sequence_19 = { 85c0 0f84e6000000 c6850801000000 33c0 }
            // n = 4, score = 200
            //   85c0                 | test                esi, esi
            //   0f84e6000000         | je                  0x1e9
            //   c6850801000000       | inc                 eax
            //   33c0                 | push                ebx

        $sequence_20 = { 4c89642430 c744242880000000 c744242002000000 4533c9 4533c0 ba00000040 }
            // n = 6, score = 200
            //   4c89642430           | jne                 0x18
            //   c744242880000000     | mov                 ebx, eax
            //   c744242002000000     | imul                ebx, eax
            //   4533c9               | mov                 ebx, eax
            //   4533c0               | imul                ebx, eax
            //   ba00000040           | test                eax, eax

        $sequence_21 = { 8bcf 85c0 0f94c1 85c9 }
            // n = 4, score = 200
            //   8bcf                 | mov                 ecx, dword ptr [eax + 0x18]
            //   85c0                 | inc                 ecx
            //   0f94c1               | mov                 ebx, 1
            //   85c9                 | dec                 esp

        $sequence_22 = { 488d8a38000000 e9???????? 488d8a28010000 e9???????? }
            // n = 4, score = 200
            //   488d8a38000000       | mov                 esi, eax
            //   e9????????           |                     
            //   488d8a28010000       | add                 esp, 0x18
            //   e9????????           |                     

        $sequence_23 = { 895c2458 eb04 8b5c2458 c685700d000000 33d2 }
            // n = 5, score = 200
            //   895c2458             | dec                 ecx
            //   eb04                 | mov                 ecx, esi
            //   8b5c2458             | dec                 eax
            //   c685700d000000       | mov                 dword ptr [esp + 0x60], ebp
            //   33d2                 | dec                 eax

        $sequence_24 = { 8bd7 3bd8 0f94c2 85d2 7419 }
            // n = 5, score = 200
            //   8bd7                 | inc                 ecx
            //   3bd8                 | mov                 ebx, 1
            //   0f94c2               | dec                 esp
            //   85d2                 | mov                 esi, dword ptr [ecx + 0x20]
            //   7419                 | dec                 ebp

        $sequence_25 = { 488d95003e0000 488bc8 e8???????? 90 }
            // n = 4, score = 100
            //   488d95003e0000       | je                  0x20
            //   488bc8               | test                eax, eax
            //   e8????????           |                     
            //   90                   | je                  0xec

        $sequence_26 = { 488d9510010000 488d4dc0 e8???????? 90 }
            // n = 4, score = 100
            //   488d9510010000       | imul                ebx, eax
            //   488d4dc0             | mov                 ebx, eax
            //   e8????????           |                     
            //   90                   | imul                ebx, eax

        $sequence_27 = { 488d9510010000 498bce ff15???????? 498bce }
            // n = 4, score = 100
            //   488d9510010000       | mov                 eax, esi
            //   498bce               | dec                 ebp
            //   ff15????????         |                     
            //   498bce               | sub                 eax, dword ptr [edi + 0x30]

        $sequence_28 = { 488d9500010000 4883bd1801000008 480f439500010000 4c8d05c2850500 }
            // n = 4, score = 100
            //   488d9500010000       | sete                cl
            //   4883bd1801000008     | test                ecx, ecx
            //   480f439500010000     | je                  0x2a1
            //   4c8d05c2850500       | mov                 ecx, edi

        $sequence_29 = { 488d9424c0000000 4883bc24d800000008 480f439424c0000000 48895c2438 c744243000f70484 48895c2428 }
            // n = 6, score = 100
            //   488d9424c0000000     | mov                 ebx, eax
            //   4883bc24d800000008     | imul    ebx, eax
            //   480f439424c0000000     | mov    dword ptr [esp + 0x58], ebx
            //   48895c2438           | jmp                 6
            //   c744243000f70484     | mov                 ebx, dword ptr [esp + 0x58]
            //   48895c2428           | mov                 byte ptr [ebp + 0xd70], 0

        $sequence_30 = { 488d9508010000 488d4c2440 e8???????? 90 488b542458 }
            // n = 5, score = 100
            //   488d9508010000       | mov                 dword ptr [ebp + 0xa0], edi
            //   488d4c2440           | mov                 dword ptr [ebp + 0x30], edi
            //   e8????????           |                     
            //   90                   | xor                 eax, eax
            //   488b542458           | test                eax, eax

    condition:
        7 of them and filesize < 1021952
}