rule win_kivars_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.kivars."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kivars"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 448bc0 488d542440 488b8c2478080000 e8???????? }
            // n = 4, score = 200
            //   448bc0               | mov                 eax, ecx
            //   488d542440           | mov                 dword ptr [esp + 0x28], eax
            //   488b8c2478080000     | mov                 eax, dword ptr [esp + 0x40]
            //   e8????????           |                     

        $sequence_1 = { e8???????? 4c8d442440 488d942464030000 488b8c24e0050000 e8???????? }
            // n = 5, score = 200
            //   e8????????           |                     
            //   4c8d442440           | mov                 ecx, eax
            //   488d942464030000     | dec                 eax
            //   488b8c24e0050000     | mov                 dword ptr [esp + 0x80], eax
            //   e8????????           |                     

        $sequence_2 = { c784247004000001000000 83bc247004000000 7548 c784247c05000000000000 488d8c2440010000 }
            // n = 5, score = 200
            //   c784247004000001000000     | mov    dword ptr [esp + 0x470], 1
            //   83bc247004000000     | cmp                 dword ptr [esp + 0x470], 0
            //   7548                 | jne                 0x4a
            //   c784247c05000000000000     | mov    dword ptr [esp + 0x57c], 0
            //   488d8c2440010000     | dec                 eax

        $sequence_3 = { e8???????? 90 488d4c2430 e8???????? 486344242c }
            // n = 5, score = 200
            //   e8????????           |                     
            //   90                   | dec                 eax
            //   488d4c2430           | mov                 eax, dword ptr [esp + 0x100]
            //   e8????????           |                     
            //   486344242c           | dec                 eax

        $sequence_4 = { 8bcb 66897304 e8???????? 83f8ff }
            // n = 4, score = 200
            //   8bcb                 | lea                 eax, [ebx + 0x66]
            //   66897304             | mov                 word ptr [esp + 0x18], dx
            //   e8????????           |                     
            //   83f8ff               | push                0

        $sequence_5 = { 85c0 7424 50 8b4354 50 ffd7 }
            // n = 6, score = 200
            //   85c0                 | cmp                 eax, ecx
            //   7424                 | jg                  0x1a1
            //   50                   | movzx               eax, word ptr [esp + 0xc0]
            //   8b4354               | dec                 eax
            //   50                   | mov                 ecx, dword ptr [esp + 0x40]
            //   ffd7                 | movzx               ecx, word ptr [ecx + 6]

        $sequence_6 = { 49 80bc0c7b0100005c 7433 bf???????? 83c9ff }
            // n = 5, score = 200
            //   49                   | cmp                 eax, ecx
            //   80bc0c7b0100005c     | xor                 eax, eax
            //   7433                 | lea                 edi, [esp + 0x18]
            //   bf????????           |                     
            //   83c9ff               | rep stosd           dword ptr es:[edi], eax

        $sequence_7 = { 33c0 8d7c2418 f3ab 8d4366 6689542418 6a00 6a00 }
            // n = 7, score = 200
            //   33c0                 | dec                 eax
            //   8d7c2418             | mov                 ecx, dword ptr [esp + 0x878]
            //   f3ab                 | nop                 
            //   8d4366               | dec                 eax
            //   6689542418           | lea                 ecx, [esp + 0x30]
            //   6a00                 | dec                 eax
            //   6a00                 | arpl                word ptr [esp + 0x2c], ax

        $sequence_8 = { 488d8c24780b0000 e8???????? e9???????? 488d542430 488d8c2440010000 }
            // n = 5, score = 200
            //   488d8c24780b0000     | lea                 ecx, [esp + 0x140]
            //   e8????????           |                     
            //   e9????????           |                     
            //   488d542430           | dec                 eax
            //   488d8c2440010000     | lea                 ecx, [esp + 0xb78]

        $sequence_9 = { 482bc8 488bc1 89442428 e9???????? 8b442440 ffc8 }
            // n = 6, score = 200
            //   482bc8               | lea                 ecx, [esp + 0x140]
            //   488bc1               | dec                 eax
            //   89442428             | mov                 eax, dword ptr [esp + 0x1060]
            //   e9????????           |                     
            //   8b442440             | dec                 eax
            //   ffc8                 | inc                 eax

        $sequence_10 = { e9???????? 488b842460100000 48ffc0 ba3a000000 }
            // n = 4, score = 200
            //   e9????????           |                     
            //   488b842460100000     | dec                 eax
            //   48ffc0               | lea                 edx, [esp + 0x30]
            //   ba3a000000           | dec                 eax

        $sequence_11 = { 51 89442420 897c2434 ff15???????? 8b4c241c }
            // n = 5, score = 200
            //   51                   | xor                 eax, eax
            //   89442420             | push                eax
            //   897c2434             | push                eax
            //   ff15????????         |                     
            //   8b4c241c             | test                eax, eax

        $sequence_12 = { 0bf0 83e23f 83c703 83c504 8a443410 }
            // n = 5, score = 200
            //   0bf0                 | je                  0x28
            //   83e23f               | push                eax
            //   83c703               | mov                 eax, dword ptr [ebx + 0x54]
            //   83c504               | push                eax
            //   8a443410             | call                edi

        $sequence_13 = { 894c244e b900080000 668b5004 33c0 50 50 }
            // n = 6, score = 200
            //   894c244e             | dec                 esp
            //   b900080000           | lea                 eax, [esp + 0x40]
            //   668b5004             | dec                 eax
            //   33c0                 | lea                 edx, [esp + 0x364]
            //   50                   | dec                 eax
            //   50                   | mov                 ecx, dword ptr [esp + 0x5e0]

        $sequence_14 = { 8d7a01 57 e8???????? 83c404 8bd8 }
            // n = 5, score = 200
            //   8d7a01               | push                0
            //   57                   | mov                 dword ptr [esp + 0x4e], ecx
            //   e8????????           |                     
            //   83c404               | mov                 ecx, 0x800
            //   8bd8                 | mov                 dx, word ptr [eax + 4]

        $sequence_15 = { 8b842400010000 488bc8 ff15???????? 4889842480000000 4883bc248000000000 }
            // n = 5, score = 200
            //   8b842400010000       | mov                 edx, 0x3a
            //   488bc8               | dec                 eax
            //   ff15????????         |                     
            //   4889842480000000     | sub                 ecx, eax
            //   4883bc248000000000     | dec    eax

    condition:
        7 of them and filesize < 196608
}