rule win_koadic_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.koadic."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.koadic"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 58 89450c 8b0424 50 58 894510 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   58                   | pop                 eax
            //   89450c               | mov                 dword ptr [ebp + 0xc], eax
            //   8b0424               | mov                 eax, dword ptr [esp]
            //   50                   | push                eax
            //   58                   | pop                 eax
            //   894510               | mov                 dword ptr [ebp + 0x10], eax

        $sequence_1 = { 884c3410 85db 75d4 85f6 7e0c 8a4c3410 }
            // n = 6, score = 100
            //   884c3410             | mov                 byte ptr [esp + esi + 0x10], cl
            //   85db                 | test                ebx, ebx
            //   75d4                 | jne                 0xffffffd6
            //   85f6                 | test                esi, esi
            //   7e0c                 | jle                 0xe
            //   8a4c3410             | mov                 cl, byte ptr [esp + esi + 0x10]

        $sequence_2 = { 89442428 ff742420 8b6c2418 58 894500 ff742424 58 }
            // n = 7, score = 100
            //   89442428             | mov                 dword ptr [esp + 0x28], eax
            //   ff742420             | push                dword ptr [esp + 0x20]
            //   8b6c2418             | mov                 ebp, dword ptr [esp + 0x18]
            //   58                   | pop                 eax
            //   894500               | mov                 dword ptr [ebp], eax
            //   ff742424             | push                dword ptr [esp + 0x24]
            //   58                   | pop                 eax

        $sequence_3 = { 740d 50 51 e8???????? 83c408 c20800 }
            // n = 6, score = 100
            //   740d                 | je                  0xf
            //   50                   | push                eax
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   c20800               | ret                 8

        $sequence_4 = { ff05???????? 8934c558344100 890cc55c344100 5e c20800 55 8bec }
            // n = 7, score = 100
            //   ff05????????         |                     
            //   8934c558344100       | mov                 dword ptr [eax*8 + 0x413458], esi
            //   890cc55c344100       | mov                 dword ptr [eax*8 + 0x41345c], ecx
            //   5e                   | pop                 esi
            //   c20800               | ret                 8
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_5 = { 8bf0 e8???????? 33ff 3bc7 740a 893e 897e04 }
            // n = 7, score = 100
            //   8bf0                 | mov                 esi, eax
            //   e8????????           |                     
            //   33ff                 | xor                 edi, edi
            //   3bc7                 | cmp                 eax, edi
            //   740a                 | je                  0xc
            //   893e                 | mov                 dword ptr [esi], edi
            //   897e04               | mov                 dword ptr [esi + 4], edi

        $sequence_6 = { 897e1c 3bc5 0f8490000000 8b4804 894e10 8b480c 894e18 }
            // n = 7, score = 100
            //   897e1c               | mov                 dword ptr [esi + 0x1c], edi
            //   3bc5                 | cmp                 eax, ebp
            //   0f8490000000         | je                  0x96
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   894e10               | mov                 dword ptr [esi + 0x10], ecx
            //   8b480c               | mov                 ecx, dword ptr [eax + 0xc]
            //   894e18               | mov                 dword ptr [esi + 0x18], ecx

        $sequence_7 = { c21000 8b442408 48 7404 33c0 eb15 8b442404 }
            // n = 7, score = 100
            //   c21000               | ret                 0x10
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   48                   | dec                 eax
            //   7404                 | je                  6
            //   33c0                 | xor                 eax, eax
            //   eb15                 | jmp                 0x17
            //   8b442404             | mov                 eax, dword ptr [esp + 4]

        $sequence_8 = { 58 a3???????? ff7508 58 }
            // n = 4, score = 100
            //   58                   | pop                 eax
            //   a3????????           |                     
            //   ff7508               | push                dword ptr [ebp + 8]
            //   58                   | pop                 eax

        $sequence_9 = { 6a08 ff35???????? ff15???????? 8bf0 33db 3bf3 }
            // n = 6, score = 100
            //   6a08                 | push                8
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   33db                 | xor                 ebx, ebx
            //   3bf3                 | cmp                 esi, ebx

    condition:
        7 of them and filesize < 180224
}