rule win_koiloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.koiloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.koiloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3bd1 72f2 c6043100 8d5e12 668b4712 33c9 66894610 }
            // n = 7, score = 600
            //   3bd1                 | cmp                 edx, ecx
            //   72f2                 | jb                  0xfffffff4
            //   c6043100             | mov                 byte ptr [ecx + esi], 0
            //   8d5e12               | lea                 ebx, [esi + 0x12]
            //   668b4712             | mov                 ax, word ptr [edi + 0x12]
            //   33c9                 | xor                 ecx, ecx
            //   66894610             | mov                 word ptr [esi + 0x10], ax

        $sequence_1 = { 88840d80fdffff 41 83f950 72ec 8d9580fdffff 8d8d98f1ffff }
            // n = 6, score = 600
            //   88840d80fdffff       | mov                 byte ptr [ebp + ecx - 0x280], al
            //   41                   | inc                 ecx
            //   83f950               | cmp                 ecx, 0x50
            //   72ec                 | jb                  0xffffffee
            //   8d9580fdffff         | lea                 edx, [ebp - 0x280]
            //   8d8d98f1ffff         | lea                 ecx, [ebp - 0xe68]

        $sequence_2 = { 83c308 03ca 894dc8 8b7904 83ef08 d1ef }
            // n = 6, score = 600
            //   83c308               | add                 ebx, 8
            //   03ca                 | add                 ecx, edx
            //   894dc8               | mov                 dword ptr [ebp - 0x38], ecx
            //   8b7904               | mov                 edi, dword ptr [ecx + 4]
            //   83ef08               | sub                 edi, 8
            //   d1ef                 | shr                 edi, 1

        $sequence_3 = { 8d8d2cfbffff e8???????? 8d8d2cfbffff e8???????? 33c9 }
            // n = 5, score = 600
            //   8d8d2cfbffff         | lea                 ecx, [ebp - 0x4d4]
            //   e8????????           |                     
            //   8d8d2cfbffff         | lea                 ecx, [ebp - 0x4d4]
            //   e8????????           |                     
            //   33c9                 | xor                 ecx, ecx

        $sequence_4 = { 8be5 5d c20400 56 8b35???????? 6a00 ffd6 }
            // n = 7, score = 600
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   56                   | push                esi
            //   8b35????????         |                     
            //   6a00                 | push                0
            //   ffd6                 | call                esi

        $sequence_5 = { 8d8d28f5ffff e8???????? 8d8d28f5ffff e8???????? 33c9 }
            // n = 5, score = 600
            //   8d8d28f5ffff         | lea                 ecx, [ebp - 0xad8]
            //   e8????????           |                     
            //   8d8d28f5ffff         | lea                 ecx, [ebp - 0xad8]
            //   e8????????           |                     
            //   33c9                 | xor                 ecx, ecx

        $sequence_6 = { 46 807c35c000 75f8 33ff 90 e8???????? 33d2 }
            // n = 7, score = 600
            //   46                   | inc                 esi
            //   807c35c000           | cmp                 byte ptr [ebp + esi - 0x40], 0
            //   75f8                 | jne                 0xfffffffa
            //   33ff                 | xor                 edi, edi
            //   90                   | nop                 
            //   e8????????           |                     
            //   33d2                 | xor                 edx, edx

        $sequence_7 = { 8b7dcc 85ff 7426 8b45d0 33c9 8d1c00 85db }
            // n = 7, score = 600
            //   8b7dcc               | mov                 edi, dword ptr [ebp - 0x34]
            //   85ff                 | test                edi, edi
            //   7426                 | je                  0x28
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]
            //   33c9                 | xor                 ecx, ecx
            //   8d1c00               | lea                 ebx, [eax + eax]
            //   85db                 | test                ebx, ebx

        $sequence_8 = { 8d4df8 51 0f47c2 50 8d8584fbffff 50 ff75f0 }
            // n = 7, score = 600
            //   8d4df8               | lea                 ecx, [ebp - 8]
            //   51                   | push                ecx
            //   0f47c2               | cmova               eax, edx
            //   50                   | push                eax
            //   8d8584fbffff         | lea                 eax, [ebp - 0x47c]
            //   50                   | push                eax
            //   ff75f0               | push                dword ptr [ebp - 0x10]

        $sequence_9 = { e8???????? 33c9 66660f1f840000000000 8a840d70edffff 88840d60ffffff 41 83f950 }
            // n = 7, score = 600
            //   e8????????           |                     
            //   33c9                 | xor                 ecx, ecx
            //   66660f1f840000000000     | nop    word ptr [eax + eax]
            //   8a840d70edffff       | mov                 al, byte ptr [ebp + ecx - 0x1290]
            //   88840d60ffffff       | mov                 byte ptr [ebp + ecx - 0xa0], al
            //   41                   | inc                 ecx
            //   83f950               | cmp                 ecx, 0x50

    condition:
        7 of them and filesize < 101376
}