rule win_kovter_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kovter"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0fb755f2 c1e202 03c2 8b00 0345fc 8bf8 46 }
            // n = 7, score = 500
            //   0fb755f2             | movzx               edx, word ptr [ebp - 0xe]
            //   c1e202               | shl                 edx, 2
            //   03c2                 | add                 eax, edx
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   0345fc               | add                 eax, dword ptr [ebp - 4]
            //   8bf8                 | mov                 edi, eax
            //   46                   | inc                 esi

        $sequence_1 = { 50 8b45fc e8???????? 5a 2bc2 83c002 50 }
            // n = 7, score = 500
            //   50                   | push                eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   5a                   | pop                 edx
            //   2bc2                 | sub                 eax, edx
            //   83c002               | add                 eax, 2
            //   50                   | push                eax

        $sequence_2 = { 58 e8???????? 85c0 7402 b301 84db 753c }
            // n = 7, score = 500
            //   58                   | pop                 eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7402                 | je                  4
            //   b301                 | mov                 bl, 1
            //   84db                 | test                bl, bl
            //   753c                 | jne                 0x3e

        $sequence_3 = { ba???????? b8???????? e8???????? 8b5588 8d458c e8???????? 8b558c }
            // n = 7, score = 500
            //   ba????????           |                     
            //   b8????????           |                     
            //   e8????????           |                     
            //   8b5588               | mov                 edx, dword ptr [ebp - 0x78]
            //   8d458c               | lea                 eax, [ebp - 0x74]
            //   e8????????           |                     
            //   8b558c               | mov                 edx, dword ptr [ebp - 0x74]

        $sequence_4 = { 8b0d???????? e8???????? a1???????? 50 e8???????? 33c0 5a }
            // n = 7, score = 500
            //   8b0d????????         |                     
            //   e8????????           |                     
            //   a1????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   5a                   | pop                 edx

        $sequence_5 = { 8b45e8 8d55ec e8???????? 8b45ec e8???????? 50 6a00 }
            // n = 7, score = 500
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   8d55ec               | lea                 edx, [ebp - 0x14]
            //   e8????????           |                     
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   e8????????           |                     
            //   50                   | push                eax
            //   6a00                 | push                0

        $sequence_6 = { eb2a 8b13 b8???????? e8???????? 85c0 }
            // n = 5, score = 500
            //   eb2a                 | jmp                 0x2c
            //   8b13                 | mov                 edx, dword ptr [ebx]
            //   b8????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_7 = { 752b 8d45f0 8b5314 e8???????? 8b55f0 8d45f4 }
            // n = 6, score = 500
            //   752b                 | jne                 0x2d
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   8b5314               | mov                 edx, dword ptr [ebx + 0x14]
            //   e8????????           |                     
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   8d45f4               | lea                 eax, [ebp - 0xc]

        $sequence_8 = { e8???????? 50 6a00 6801001f00 e8???????? 8bf0 85f6 }
            // n = 7, score = 500
            //   e8????????           |                     
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6801001f00           | push                0x1f0001
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi

        $sequence_9 = { b8???????? e8???????? 8bc8 49 8b03 8b00 ba01000000 }
            // n = 7, score = 500
            //   b8????????           |                     
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   49                   | dec                 ecx
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   ba01000000           | mov                 edx, 1

    condition:
        7 of them and filesize < 901120
}